/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.plugins.workflow;

import java.util.Collections;
import java.util.Map;
import qupath.lib.common.GeneralTools;
import qupath.lib.plugins.workflow.ScriptableWorkflowStep;

public class RunSavedClassifierWorkflowStep
implements ScriptableWorkflowStep {
    private static final long serialVersionUID = 1L;
    private String name;
    private String classifierPath;

    public RunSavedClassifierWorkflowStep(String name, String classifierPath) {
        this.name = name;
        this.classifierPath = GeneralTools.escapeFilePath(classifierPath);
    }

    public RunSavedClassifierWorkflowStep(String classifierPath) {
        this("Run object classifier", classifierPath);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Map<String, ?> getParameterMap() {
        return Collections.singletonMap("Path", this.classifierPath);
    }

    public String toString() {
        return this.getName() + "\t" + this.getScript();
    }

    @Override
    public String getScript() {
        return "runClassifier('" + this.classifierPath + "')";
    }
}

