/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.plugins.parameters;

import com.google.gson.JsonElement;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.io.GsonTools;
import qupath.lib.objects.classes.PathClass;
import qupath.lib.plugins.parameters.BooleanParameter;
import qupath.lib.plugins.parameters.ChoiceParameter;
import qupath.lib.plugins.parameters.DoubleParameter;
import qupath.lib.plugins.parameters.EmptyParameter;
import qupath.lib.plugins.parameters.IntParameter;
import qupath.lib.plugins.parameters.Parameter;
import qupath.lib.plugins.parameters.StringParameter;

public class ParameterList
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(ParameterList.class);
    private Map<String, Parameter<?>> params = new LinkedHashMap();
    private int titleCount = 1;
    private int emptyCount = 1;

    private static ParameterList copyParameters(ParameterList params) {
        ParameterList paramsCopy = new ParameterList();
        for (Map.Entry<String, Parameter<?>> entry : params.params.entrySet()) {
            paramsCopy.params.put(entry.getKey(), entry.getValue().duplicate());
        }
        return paramsCopy;
    }

    public void setHiddenParameters(boolean hidden, String ... keys) {
        for (String key : keys) {
            this.params.get(key).setHidden(hidden);
        }
    }

    public ParameterList duplicate() {
        return ParameterList.copyParameters(this);
    }

    public ParameterList addDoubleParameter(String key, String prompt, double defaultValue) {
        return this.addDoubleParameter(key, prompt, defaultValue, null, null);
    }

    public ParameterList addDoubleParameter(String key, String prompt, double defaultValue, String unit, String helpText) {
        this.params.put(key, new DoubleParameter(prompt, defaultValue, unit, helpText));
        return this;
    }

    public ParameterList addDoubleParameter(String key, String prompt, double defaultValue, String unit, double lowerBound, double upperBound, String helpText) {
        this.params.put(key, new DoubleParameter(prompt, defaultValue, unit, (Double)lowerBound, (Double)upperBound, helpText));
        return this;
    }

    public ParameterList addIntParameter(String key, String prompt, int defaultValue) {
        return this.addIntParameter(key, prompt, defaultValue, null, null);
    }

    public ParameterList addIntParameter(String key, String prompt, int defaultValue, String unit, String helpText) {
        this.params.put(key, new IntParameter(prompt, defaultValue, unit, helpText));
        return this;
    }

    public ParameterList addIntParameter(String key, String prompt, int defaultValue, String unit, double lowerBound, double upperBound, String helpText) {
        this.params.put(key, new IntParameter(prompt, defaultValue, unit, (Double)lowerBound, (Double)upperBound, helpText));
        return this;
    }

    public ParameterList addEmptyParameter(String prompt) {
        this.params.put("empty" + this.emptyCount, new EmptyParameter(prompt));
        ++this.emptyCount;
        return this;
    }

    ParameterList addEmptyParameter(String key, String prompt, boolean isTitle) {
        this.params.put(key, new EmptyParameter(prompt, isTitle));
        return this;
    }

    public ParameterList addTitleParameter(String prompt) {
        this.addEmptyParameter("title" + this.titleCount, prompt, true);
        ++this.titleCount;
        return this;
    }

    public ParameterList addBooleanParameter(String key, String prompt, boolean defaultValue) {
        return this.addBooleanParameter(key, prompt, defaultValue, null);
    }

    public ParameterList addBooleanParameter(String key, String prompt, boolean defaultValue, String helpText) {
        this.params.put(key, new BooleanParameter(prompt, defaultValue, helpText));
        return this;
    }

    public ParameterList addStringParameter(String key, String prompt, String defaultValue) {
        return this.addStringParameter(key, prompt, defaultValue, null);
    }

    public ParameterList addStringParameter(String key, String prompt, String defaultValue, String helpText) {
        this.params.put(key, new StringParameter(prompt, defaultValue, helpText));
        return this;
    }

    public <S> ParameterList addChoiceParameter(String key, String prompt, S defaultValue, List<S> choices) {
        return this.addChoiceParameter(key, prompt, defaultValue, choices, null);
    }

    public <S> ParameterList addChoiceParameter(String key, String prompt, S defaultValue, List<S> choices, String helpText) {
        this.params.put(key, new ChoiceParameter<S>(prompt, defaultValue, choices, helpText));
        return this;
    }

    public Map<String, Parameter<?>> getParameters() {
        return Collections.unmodifiableMap(this.params);
    }

    public Map<String, Object> getKeyValueParameters(boolean includeHidden) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Parameter<?>> entry : this.getParameters().entrySet()) {
            Parameter<?> p = entry.getValue();
            if (p instanceof EmptyParameter || !includeHidden && p.isHidden()) continue;
            map.put(entry.getKey(), p.getValueOrDefault());
        }
        return map;
    }

    public boolean containsKey(Object key) {
        return this.params.containsKey(key);
    }

    Boolean getBooleanParameterValue(String key, Boolean defaultValue) {
        Parameter<?> p = this.params.get(key);
        if (p instanceof BooleanParameter) {
            return (Boolean)((BooleanParameter)p).getValueOrDefault();
        }
        throw new IllegalArgumentException("No boolean parameter with key '" + key + "'");
    }

    Double getDoubleParameterValue(String key, Double defaultValue) {
        Parameter<?> p = this.params.get(key);
        if (p instanceof DoubleParameter) {
            return (Double)((DoubleParameter)p).getValueOrDefault();
        }
        throw new IllegalArgumentException("No double parameter with key '" + key + "'");
    }

    Integer getIntParameterValue(String key, Integer defaultValue) {
        Parameter<?> p = this.params.get(key);
        if (p instanceof IntParameter) {
            return (Integer)((IntParameter)p).getValueOrDefault();
        }
        throw new IllegalArgumentException("No integer parameter with key '" + key + "'");
    }

    String getStringParameterValue(String key, String defaultValue) {
        Parameter<?> p = this.params.get(key);
        if (p instanceof StringParameter) {
            return (String)((StringParameter)p).getValueOrDefault();
        }
        throw new IllegalArgumentException("No String parameter with key '" + key + "'");
    }

    Object getChoiceParameterValue(String key, Object defaultValue) {
        Parameter<?> p = this.params.get(key);
        if (p instanceof ChoiceParameter) {
            return ((ChoiceParameter)p).getValueOrDefault();
        }
        throw new IllegalArgumentException("No choice parameter with key '" + key + "'");
    }

    public Boolean getBooleanParameterValue(String key) {
        return this.getBooleanParameterValue(key, null);
    }

    public Double getDoubleParameterValue(String key) {
        return this.getDoubleParameterValue(key, Double.NaN);
    }

    public Integer getIntParameterValue(String key) {
        return this.getIntParameterValue(key, null);
    }

    public String getStringParameterValue(String key) {
        return this.getStringParameterValue(key, null);
    }

    public Object getChoiceParameterValue(String key) {
        return this.getChoiceParameterValue(key, null);
    }

    public Parameter<?> removeParameter(String key) {
        return this.params.remove(key);
    }

    public boolean removeEmptyParameters() {
        Iterator<Map.Entry<String, Parameter<?>>> iter = this.params.entrySet().iterator();
        boolean changes = false;
        while (iter.hasNext()) {
            if (!(iter.next().getValue() instanceof EmptyParameter)) continue;
            iter.remove();
            changes = true;
        }
        return changes;
    }

    public static void updateParameterList(ParameterList params, Map<String, String> mapNew, Locale locale) {
        Map<String, Parameter<?>> mapParams = params.getParameters();
        for (Map.Entry<String, String> entry : mapNew.entrySet()) {
            String key = entry.getKey();
            Parameter<?> parameter = mapParams.get(key);
            if (parameter == null || !parameter.setStringLastValue(locale, entry.getValue())) {
                logger.warn("Unable to set parameter {} with value {}", (Object)key, (Object)entry.getValue());
                continue;
            }
            parameter.setStringLastValue(locale, entry.getValue());
        }
    }

    public static boolean equalParameters(ParameterList params1, ParameterList params2) {
        if (params1 == null) {
            return params2 != null;
        }
        Map<String, Parameter<?>> map1 = params1.getParameters();
        Map<String, Parameter<?>> map2 = params2.getParameters();
        if (!map2.keySet().equals(map1.keySet())) {
            return false;
        }
        for (Map.Entry<String, Parameter<?>> entry1 : map1.entrySet()) {
            Parameter<?> param2;
            Parameter<?> param1 = entry1.getValue();
            if (param1 == (param2 = map2.get(entry1.getKey()))) continue;
            if (param1.getClass() != param2.getClass()) {
                return true;
            }
            Object value1 = param1.getValueOrDefault();
            Object value2 = param2.getValueOrDefault();
            if (value1 == null) {
                if (value2 == null) continue;
                return true;
            }
            if (value1.equals(value2)) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public static String getParameterListJSON(ParameterList params, String delimiter) {
        Map<String, Object> map = params.getKeyValueParameters(false);
        return ParameterList.getParameterListJSON(map, delimiter);
    }

    @Deprecated
    public static String getParameterListJSON(Map<String, ?> map, String delimiter) {
        StringBuilder sb = new StringBuilder();
        int counter = 0;
        sb.append("{");
        for (Map.Entry<String, ?> entry : map.entrySet()) {
            if (counter > 0) {
                sb.append(delimiter);
            }
            ++counter;
            sb.append("\"").append(entry.getKey()).append("\"");
            sb.append(": ");
            Object value = entry.getValue();
            if (value == null) {
                sb.append("null");
            } else if (value instanceof Boolean) {
                sb.append(value.toString());
            } else if (value instanceof Number) {
                sb.append(value.toString());
            } else {
                sb.append("\"").append(value).append("\"");
            }
            if (counter >= map.size()) continue;
            sb.append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public static String convertToJson(Map<String, ?> map) {
        return GsonTools.getDefaultBuilder().registerTypeAdapter(PathClass.class, (Object)new PathClassStringSerializer()).create().toJson(map);
    }

    public static String convertToJson(ParameterList params) {
        Map<String, Object> map = params.getKeyValueParameters(false);
        String json = ParameterList.convertToJson(map);
        return json;
    }

    private static class PathClassStringSerializer
    implements JsonSerializer<PathClass> {
        private PathClassStringSerializer() {
        }

        public JsonElement serialize(PathClass src, Type typeOfSrc, JsonSerializationContext context) {
            if (src == null) {
                return context.serialize(null);
            }
            return context.serialize((Object)src.toString());
        }
    }
}

