/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.plugins.parameters;

import java.util.Locale;
import qupath.lib.plugins.parameters.AbstractParameter;
import qupath.lib.plugins.parameters.Parameter;

public class BooleanParameter
extends AbstractParameter<Boolean> {
    private static final long serialVersionUID = 1L;

    BooleanParameter(String prompt, Boolean defaultValue, Boolean lastValue, String helpText, boolean isHidden) {
        super(prompt, defaultValue, lastValue, helpText, isHidden);
    }

    BooleanParameter(String prompt, Boolean defaultValue, Boolean lastValue, String helpText) {
        this(prompt, defaultValue, lastValue, helpText, false);
    }

    BooleanParameter(String prompt, Boolean defaultValue, String helpText) {
        this(prompt, defaultValue, null, helpText);
    }

    @Override
    public boolean setStringLastValue(Locale locale, String value) {
        try {
            boolean b = Boolean.parseBoolean(value);
            return this.setValue((Object)b);
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public boolean isValidInput(Boolean value) {
        return value != null;
    }

    @Override
    public Parameter<Boolean> duplicate() {
        return new BooleanParameter(this.getPrompt(), (Boolean)this.getDefaultValue(), (Boolean)this.getValue(), this.getHelpText(), this.isHidden());
    }
}

