/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.plugins.parameters;

import qupath.lib.plugins.parameters.Parameter;

abstract class AbstractParameter<S>
implements Parameter<S> {
    private static final long serialVersionUID = 1L;
    private String prompt = null;
    private S defaultValue;
    private String helpText = null;
    private boolean hidden = false;
    protected S lastValue = null;

    AbstractParameter(String prompt, S defaultValue, S value, String helpText, boolean hidden) {
        this.prompt = prompt;
        this.defaultValue = defaultValue;
        this.lastValue = value;
        this.helpText = helpText;
        this.hidden = hidden;
    }

    @Override
    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    @Override
    public boolean isHidden() {
        return this.hidden;
    }

    @Override
    public S getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public S getValue() {
        return this.lastValue;
    }

    @Override
    public void resetValue() {
        this.lastValue = null;
    }

    @Override
    public S getValueOrDefault() {
        if (this.lastValue != null) {
            return this.lastValue;
        }
        return this.defaultValue;
    }

    @Override
    public String getPrompt() {
        return this.prompt;
    }

    @Override
    public boolean setValue(S value) {
        if (!this.isValidInput(value)) {
            return false;
        }
        this.lastValue = value;
        return true;
    }

    public String toString() {
        return this.getPrompt().replace(":", "-") + ":\t" + String.valueOf(this.getValueOrDefault());
    }

    @Override
    public boolean hasHelpText() {
        return this.getHelpText() != null;
    }

    @Override
    public String getHelpText() {
        return this.helpText;
    }
}

