/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.plugins;

import java.util.function.IntFunction;
import qupath.lib.common.ThreadTools;
import qupath.lib.plugins.CommandLineTaskRunner;
import qupath.lib.plugins.TaskRunner;

public class TaskRunnerUtils {
    private static IntFunction<TaskRunner> DEFAULT_HEADLESS_FUNCTION = nThreads -> new CommandLineTaskRunner(nThreads);
    private IntFunction<TaskRunner> headlessFunction = DEFAULT_HEADLESS_FUNCTION;
    private IntFunction<TaskRunner> function = DEFAULT_HEADLESS_FUNCTION;
    private static TaskRunnerUtils INSTANCE = new TaskRunnerUtils();

    private TaskRunnerUtils() {
    }

    public static TaskRunnerUtils getDefaultInstance() {
        return INSTANCE;
    }

    public static TaskRunnerUtils newInstance() {
        return new TaskRunnerUtils();
    }

    public static IntFunction<TaskRunner> getDefaultCreateFunction() {
        return DEFAULT_HEADLESS_FUNCTION;
    }

    public TaskRunnerUtils setCreateHeadlessFunction(IntFunction<TaskRunner> function) {
        this.headlessFunction = function;
        return this;
    }

    public TaskRunnerUtils setCreateFunction(IntFunction<TaskRunner> function) {
        this.function = function;
        return this;
    }

    public TaskRunner createTaskRunner() {
        return this.createTaskRunner(ThreadTools.getParallelism());
    }

    public TaskRunner createTaskRunner(int nThreads) {
        return this.function.apply(nThreads);
    }

    public TaskRunner createHeadlessTaskRunner() {
        return this.createHeadlessTaskRunner(ThreadTools.getParallelism());
    }

    public TaskRunner createHeadlessTaskRunner(int nThreads) {
        return this.headlessFunction.apply(nThreads);
    }
}

