/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.plugins;

import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.locationtech.jts.geom.Geometry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.common.ColorTools;
import qupath.lib.objects.DefaultPathObjectComparator;
import qupath.lib.objects.PathObject;
import qupath.lib.objects.PathObjectTools;
import qupath.lib.objects.PathROIObject;
import qupath.lib.objects.PathTileObject;
import qupath.lib.objects.TemporaryObject;
import qupath.lib.objects.classes.PathClass;
import qupath.lib.objects.hierarchy.PathObjectHierarchy;
import qupath.lib.plugins.AbstractTileableDetectionPlugin;
import qupath.lib.regions.ImageRegion;
import qupath.lib.roi.interfaces.ROI;

public class ParallelTileObject
extends PathTileObject
implements TemporaryObject {
    private static final Logger logger = LoggerFactory.getLogger(ParallelTileObject.class);
    private static PathClass pathClassPending = PathClass.getInstance("Tile-Pending", ColorTools.packRGB(50, 50, 200));
    private static PathClass pathClassProcessing = PathClass.getInstance("Tile-Processing", ColorTools.packRGB(50, 200, 50));
    private static PathClass pathClassDone = PathClass.getInstance("Tile-Done", ColorTools.packRGB(100, 20, 20));
    private AbstractTileableDetectionPlugin.ParallelDetectionTileManager manager;
    AtomicInteger countdown;
    Rectangle2D bounds;
    PathObjectHierarchy hierarchy;
    Map<ParallelTileObject, Rectangle2D> map = new TreeMap<PathObject, Rectangle2D>(DefaultPathObjectComparator.getInstance());
    private Status status = Status.PENDING;

    ParallelTileObject(AbstractTileableDetectionPlugin.ParallelDetectionTileManager manager, ROI pathROI, PathObjectHierarchy hierarchy, AtomicInteger countdown) {
        super(pathROI);
        this.manager = manager;
        this.setPathClass(pathClassPending);
        this.bounds = ParallelTileObject.getBounds2D(pathROI);
        this.hierarchy = hierarchy;
        this.countdown = countdown;
        this.setColor(ColorTools.packRGB(128, 128, 128));
    }

    public synchronized boolean suggestNeighbor(ParallelTileObject pto) {
        if (this.bounds.intersects(pto.bounds)) {
            Rectangle2D.Double intersection = new Rectangle2D.Double();
            Rectangle2D.intersect(this.bounds, pto.bounds, intersection);
            this.map.put(pto, intersection);
            return true;
        }
        return false;
    }

    public synchronized void updateStatus(Status status) {
        Objects.requireNonNull(status);
        this.status = status;
        switch (status.ordinal()) {
            case 2: {
                this.setPathClass(pathClassDone);
                break;
            }
            case 1: {
                this.setPathClass(pathClassProcessing);
                break;
            }
            default: {
                this.setPathClass(pathClassPending);
            }
        }
    }

    public Status getStatus() {
        return this.status;
    }

    public synchronized boolean isProcessing() {
        return this.status == Status.PROCESSING;
    }

    public synchronized boolean isComplete() {
        return this.status == Status.DONE;
    }

    public synchronized void setComplete(boolean wasCancelled) {
        this.updateStatus(Status.DONE);
        this.manager.tileComplete(this, wasCancelled);
    }

    public synchronized void resolveOverlaps() {
        long startTime = System.currentTimeMillis();
        int nRemoved = 0;
        boolean preferNucleus = false;
        Iterator<Map.Entry<ParallelTileObject, Rectangle2D>> iterMap = this.map.entrySet().iterator();
        while (iterMap.hasNext()) {
            ParallelTileObject second;
            ParallelTileObject first;
            Map.Entry<ParallelTileObject, Rectangle2D> entry = iterMap.next();
            ParallelTileObject pto = entry.getKey();
            if (!pto.isComplete()) continue;
            if (this.getROI().getBoundsX() > pto.getROI().getBoundsX() || this.getROI().getBoundsY() > pto.getROI().getBoundsY()) {
                first = this;
                second = pto;
            } else {
                first = pto;
                second = this;
            }
            List<PathObject> listFirst = first.getObjectsForRegion(entry.getValue());
            List<PathObject> listSecond = second.getObjectsForRegion(entry.getValue());
            if (!listFirst.isEmpty() && !listSecond.isEmpty()) {
                HashMap<ROI, Geometry> cache = new HashMap<ROI, Geometry>();
                block3: for (PathObject firstObject : listFirst) {
                    ROI firstROI = PathObjectTools.getROI(firstObject, preferNucleus);
                    ImageRegion firstRegion = ImageRegion.createInstance(firstROI);
                    Geometry firstGeometry = null;
                    double firstArea = Double.NaN;
                    for (PathObject secondObject : listSecond) {
                        Geometry intersection;
                        Geometry secondGeometry;
                        ROI secondROI = PathObjectTools.getROI(secondObject, preferNucleus);
                        if (!firstRegion.intersects(secondROI.getBoundsX(), secondROI.getBoundsY(), secondROI.getBoundsWidth(), secondROI.getBoundsHeight())) continue;
                        if (firstGeometry == null) {
                            firstGeometry = firstROI.getGeometry();
                            firstArea = firstGeometry.getArea();
                        }
                        if ((secondGeometry = (Geometry)cache.get(secondROI)) == null) {
                            secondGeometry = secondROI.getGeometry();
                            cache.put(secondROI, secondGeometry);
                        }
                        try {
                            if (!firstGeometry.intersects(secondGeometry)) continue;
                            intersection = firstGeometry.intersection(secondGeometry);
                        }
                        catch (Exception e) {
                            logger.warn("Error resolving overlaps: {}", (Object)e.getLocalizedMessage());
                            logger.debug(e.getLocalizedMessage(), (Throwable)e);
                            continue;
                        }
                        if (intersection.isEmpty()) continue;
                        double intersectionArea = intersection.getArea();
                        double secondArea = secondGeometry.getArea();
                        double threshold = 0.1;
                        if (firstArea >= secondArea) {
                            if (!(intersectionArea / secondArea > threshold)) continue;
                            second.removeChildObject(secondObject);
                            ++nRemoved;
                            continue;
                        }
                        if (!(intersectionArea / firstArea > threshold)) continue;
                        first.removeChildObject(firstObject);
                        ++nRemoved;
                        continue block3;
                    }
                }
            }
            iterMap.remove();
            pto.notifyTestComplete(this);
        }
        this.checkAllTestsComplete();
        long endTime = System.currentTimeMillis();
        logger.debug(String.format("Resolved %d overlaps: %.2f seconds", nRemoved, (double)(endTime - startTime) / 1000.0));
    }

    List<PathObject> getObjectsForRegion(Rectangle2D region) {
        ArrayList<PathObject> pathObjects = new ArrayList<PathObject>();
        for (PathObject child : this.getChildObjectsAsArray()) {
            ROI childROI = child.getROI();
            if (childROI == null || !childROI.isArea() || !region.intersects(ParallelTileObject.getBounds2D(childROI))) continue;
            pathObjects.add(child);
        }
        Collections.sort(pathObjects, DefaultPathObjectComparator.getInstance());
        return pathObjects;
    }

    boolean checkAllTestsComplete() {
        if (this.map.isEmpty() && this.getParent() != null) {
            if (this.countdown == null) {
                this.hierarchy.removeObject(this, true);
            } else if (this.countdown.decrementAndGet() == 0) {
                PathObject parent = this.getParent();
                ArrayList<PathObject> parallelObjects = new ArrayList<PathObject>();
                for (PathObject temp : parent.getChildObjectsAsArray()) {
                    if (!(temp instanceof ParallelTileObject)) continue;
                    parallelObjects.add(temp);
                }
                parent.removeChildObjects(parallelObjects);
                for (PathObject temp : parallelObjects) {
                    parent.addChildObjects(temp.getChildObjects());
                }
                if (parent.hasChildObjects() && parent instanceof PathROIObject) {
                    ((PathROIObject)parent).setLocked(true);
                }
                this.hierarchy.fireHierarchyChangedEvent(parent);
            }
            return true;
        }
        return false;
    }

    void notifyTestComplete(ParallelTileObject pto) {
        if (this.isComplete()) {
            this.map.remove(pto);
            this.checkAllTestsComplete();
        }
    }

    private static Rectangle2D getBounds2D(ROI pathROI) {
        return new Rectangle2D.Double(pathROI.getBoundsX(), pathROI.getBoundsY(), pathROI.getBoundsWidth(), pathROI.getBoundsHeight());
    }

    public static enum Status {
        PENDING,
        PROCESSING,
        DONE;

    }
}

