/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.plugins;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.images.ImageData;
import qupath.lib.objects.PathObject;
import qupath.lib.objects.PathROIObject;
import qupath.lib.plugins.ObjectDetector;
import qupath.lib.plugins.ParallelTileObject;
import qupath.lib.plugins.PathTask;
import qupath.lib.plugins.parameters.ParameterList;
import qupath.lib.roi.interfaces.ROI;

public class DetectionPluginTools {
    public static <T> Runnable createRunnableTask(ObjectDetector<T> task, ParameterList params, ImageData<T> imageData, PathObject parentObject) {
        return new DetectionRunnable<T>(task, params, imageData, parentObject);
    }

    static class DetectionRunnable<T>
    implements PathTask {
        private static final Logger logger = LoggerFactory.getLogger(DetectionPluginTools.class);
        ObjectDetector<T> detector;
        private ParameterList params;
        private PathObject parentObject;
        private ROI roi;
        private ImageData<T> imageData;
        private String result;
        private Collection<PathObject> pathObjectsDetected;

        public DetectionRunnable(ObjectDetector<T> detector, ParameterList params, ImageData<T> imageData, PathObject parentObject) {
            this.detector = detector;
            this.params = params;
            this.parentObject = parentObject;
            this.imageData = imageData;
            this.roi = parentObject != null ? parentObject.getROI() : null;
        }

        protected boolean checkROI() {
            return this.roi == null || !this.roi.isPoint();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block10: {
                try {
                    long startTime = System.currentTimeMillis();
                    if (this.parentObject instanceof ParallelTileObject) {
                        ((ParallelTileObject)this.parentObject).updateStatus(ParallelTileObject.Status.PROCESSING);
                        this.imageData.getHierarchy().fireObjectClassificationsChangedEvent(this, Collections.singleton(this.parentObject));
                    }
                    if (this.checkROI()) {
                        try {
                            this.pathObjectsDetected = this.detector.runDetection(this.imageData, this.params, this.roi);
                        }
                        catch (IOException e) {
                            logger.error("Error processing " + String.valueOf(this.roi), (Throwable)e);
                        }
                        this.result = this.detector.getLastResultsDescription();
                        long endTime = System.currentTimeMillis();
                        if (this.result != null) {
                            logger.info(this.result + String.format(" (processing time: %.2f seconds)", (double)(endTime - startTime) / 1000.0));
                        } else {
                            logger.info(String.valueOf(this.parentObject) + String.format(" (processing time: %.2f seconds)", (double)(endTime - startTime) / 1000.0));
                        }
                        break block10;
                    }
                    logger.info("Cannot run detection using ROI {}", (Object)this.roi);
                }
                finally {
                    if (this.parentObject instanceof ParallelTileObject) {
                        ((ParallelTileObject)this.parentObject).updateStatus(ParallelTileObject.Status.DONE);
                        this.imageData.getHierarchy().fireObjectClassificationsChangedEvent(this, Collections.singleton(this.parentObject));
                    }
                }
            }
        }

        private static void tryToSetObjectLock(PathObject pathObject, boolean locked) {
            if (pathObject instanceof PathROIObject) {
                ((PathROIObject)pathObject).setLocked(locked);
            }
        }

        @Override
        public void taskComplete(boolean wasCancelled) {
            if (this.parentObject == null) {
                return;
            }
            try {
                if (this.parentObject instanceof ParallelTileObject) {
                    this.parentObject.clearChildObjects();
                    this.parentObject.addChildObjects(this.pathObjectsDetected);
                    ((ParallelTileObject)this.parentObject).setComplete(wasCancelled);
                } else if (!wasCancelled) {
                    this.parentObject.clearChildObjects();
                    if (this.pathObjectsDetected != null) {
                        this.parentObject.addChildObjects(this.pathObjectsDetected);
                        DetectionRunnable.tryToSetObjectLock(this.parentObject, !this.pathObjectsDetected.isEmpty());
                    }
                    this.imageData.getHierarchy().fireObjectsChangedEvent(this, Collections.singletonList(this.parentObject));
                }
            }
            finally {
                this.pathObjectsDetected = null;
                this.parentObject = null;
                this.imageData = null;
                this.roi = null;
                this.detector = null;
            }
        }

        @Override
        public String getLastResultsDescription() {
            return this.result;
        }
    }
}

