/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.plugins;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.geom.ImmutableDimension;
import qupath.lib.images.ImageData;
import qupath.lib.images.servers.ImageServer;
import qupath.lib.images.servers.ServerTools;
import qupath.lib.objects.PathObject;
import qupath.lib.plugins.AbstractDetectionPlugin;
import qupath.lib.plugins.DetectionPluginTools;
import qupath.lib.plugins.ObjectDetector;
import qupath.lib.plugins.ParallelTileObject;
import qupath.lib.plugins.parameters.ParameterList;
import qupath.lib.regions.ImagePlane;
import qupath.lib.roi.ROIs;
import qupath.lib.roi.RoiTools;
import qupath.lib.roi.interfaces.ROI;

public abstract class AbstractTileableDetectionPlugin<T>
extends AbstractDetectionPlugin<T> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractTileableDetectionPlugin.class);
    private static int PREFERRED_TILE_SIZE = 2048;
    private static int MAX_TILE_SIZE = 3072;

    protected abstract double getPreferredPixelSizeMicrons(ImageData<T> var1, ParameterList var2);

    protected abstract ObjectDetector<T> createDetector(ImageData<T> var1, ParameterList var2);

    protected abstract int getTileOverlap(ImageData<T> var1, ParameterList var2);

    @Override
    protected void addRunnableTasks(ImageData<T> imageData, PathObject parentObject, List<Runnable> tasks) {
        if (imageData == null) {
            return;
        }
        ParameterList params = this.getParameterList(imageData);
        ImageServer<T> server = imageData.getServer();
        double downsampleFactor = ServerTools.getDownsampleFactor(server, this.getPreferredPixelSizeMicrons(imageData, params));
        int preferred = (int)((double)PREFERRED_TILE_SIZE * downsampleFactor);
        int max = (int)((double)MAX_TILE_SIZE * downsampleFactor);
        ImmutableDimension sizePreferred = ImmutableDimension.getInstance(preferred, preferred);
        ImmutableDimension sizeMax = ImmutableDimension.getInstance(max, max);
        ROI parentROI = parentObject.getROI();
        if (parentROI == null) {
            parentROI = ROIs.createRectangleROI(0.0, 0.0, server.getWidth(), server.getHeight(), ImagePlane.getDefaultPlane());
        } else if (parentROI.getBoundsX() < 0.0 || parentROI.getBoundsY() < 0.0 || parentROI.getBoundsX() + parentROI.getBoundsWidth() >= (double)server.getWidth() || parentROI.getBoundsY() + parentROI.getBoundsHeight() >= (double)server.getHeight()) {
            logger.debug("Parent ROI is out of bounds; adjusting to image bounds");
            parentROI = RoiTools.combineROIs(parentROI, ROIs.createRectangleROI(0.0, 0.0, server.getWidth(), server.getHeight(), parentROI.getImagePlane()), RoiTools.CombineOp.INTERSECT);
        }
        Collection<? extends ROI> pathROIs = RoiTools.computeTiledROIs(parentROI, sizePreferred, sizeMax, false, this.getTileOverlap(imageData, params));
        if (pathROIs.isEmpty()) {
            return;
        }
        ParallelDetectionTileManager manager = new ParallelDetectionTileManager(parentObject);
        ArrayList<ParallelTileObject> tileList = new ArrayList<ParallelTileObject>();
        AtomicInteger countdown = new AtomicInteger(pathROIs.size());
        for (ROI rOI : pathROIs) {
            ParallelTileObject tile = new ParallelTileObject(manager, rOI, imageData.getHierarchy(), countdown);
            parentObject.addChildObject(tile);
            for (ParallelTileObject tileTemp : tileList) {
                if (!tileTemp.suggestNeighbor(tile)) continue;
                tile.suggestNeighbor(tileTemp);
            }
            tileList.add(tile);
            tasks.add(DetectionPluginTools.createRunnableTask(this.createDetector(imageData, params), params, imageData, tile));
        }
        manager.setTiles(tileList);
        imageData.getHierarchy().fireHierarchyChangedEvent(this);
    }

    static class ParallelDetectionTileManager {
        private PathObject parent;
        private List<PathObject> originalChildObjects;
        private boolean wasCancelled = false;
        private AtomicInteger countdown;
        private List<ParallelTileObject> tiles = new ArrayList<ParallelTileObject>();

        ParallelDetectionTileManager(PathObject parent) {
            this.parent = parent;
            this.originalChildObjects = new ArrayList<PathObject>(parent.getChildObjects());
        }

        public void setTiles(Collection<ParallelTileObject> tiles) {
            this.tiles = new ArrayList<ParallelTileObject>(tiles);
            this.countdown = new AtomicInteger(tiles.size());
            this.parent.clearChildObjects();
            this.parent.addChildObjects(tiles);
        }

        public void tileComplete(PathObject tile, boolean wasCancelled) {
            int remaining;
            if (wasCancelled) {
                this.wasCancelled = true;
            }
            if ((remaining = this.countdown.decrementAndGet()) == 0) {
                this.postprocess();
            }
        }

        private void postprocess() {
            this.parent.clearChildObjects();
            if (this.wasCancelled) {
                this.parent.addChildObjects(this.originalChildObjects);
            } else {
                for (ParallelTileObject tile : this.tiles) {
                    tile.resolveOverlaps();
                    this.parent.addChildObjects(tile.getChildObjects());
                }
                if (this.parent.hasChildObjects()) {
                    this.parent.setLocked(true);
                }
            }
        }
    }
}

