/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.plugins;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.common.ThreadTools;
import qupath.lib.plugins.PathTask;
import qupath.lib.plugins.SimpleProgressMonitor;
import qupath.lib.plugins.TaskRunner;

public abstract class AbstractTaskRunner
implements TaskRunner {
    private static final Logger logger = LoggerFactory.getLogger(AbstractTaskRunner.class);
    private static int counter = 0;
    private ExecutorService pool;
    private ExecutorCompletionService<Runnable> service;
    private Map<Future<Runnable>, Runnable> pendingTasks = new ConcurrentHashMap<Future<Runnable>, Runnable>();
    private SimpleProgressMonitor monitor;
    private boolean tasksCancelled = false;
    private int numThreads;

    protected AbstractTaskRunner() {
        this(-1);
    }

    protected AbstractTaskRunner(int numThreads) {
        this.numThreads = numThreads;
    }

    protected abstract SimpleProgressMonitor makeProgressMonitor();

    @Override
    public synchronized void runTasks(String message, Collection<? extends Runnable> tasks) {
        if (tasks.isEmpty()) {
            return;
        }
        this.tasksCancelled = false;
        if (this.pool == null || this.pool.isShutdown()) {
            int n = this.numThreads <= 0 ? ThreadTools.getParallelism() : this.numThreads;
            this.pool = Executors.newFixedThreadPool(n, ThreadTools.createThreadFactory("task-runner-" + ++counter + "-", false));
            logger.debug("New threadpool created with {} threads", (Object)n);
            this.service = new ExecutorCompletionService(this.pool);
        } else if (this.service == null) {
            this.service = new ExecutorCompletionService(this.pool);
        }
        this.monitor = this.makeProgressMonitor();
        this.monitor.startMonitoring(message, tasks.size(), true);
        for (Runnable runnable : tasks) {
            if (runnable == null) {
                logger.warn("Skipping null task");
                continue;
            }
            Future<Runnable> future = this.service.submit(runnable, runnable);
            this.pendingTasks.put(future, runnable);
        }
        this.pool.shutdown();
        this.awaitCompletion();
        this.postProcess(tasks.stream().filter(t -> t instanceof PathTask).map(t -> (PathTask)t).toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void awaitCompletion() {
        try {
            while (!this.pendingTasks.isEmpty()) {
                Future<Runnable> future = null;
                if (!this.tasksCancelled && this.monitor != null && this.monitor.cancelled() && (future = this.service.poll()) == null) {
                    for (Future entry : this.pendingTasks.keySet().toArray(new Future[0])) {
                        if (entry.cancel(true)) {
                            this.pendingTasks.remove(entry);
                            this.monitor.updateProgress(1, "", null);
                            continue;
                        }
                        logger.debug("Cancel returned false for {}", (Object)entry);
                    }
                    this.tasksCancelled = true;
                }
                Future<Runnable> future2 = future = future == null ? this.service.take() : future;
                if (!future.isCancelled()) {
                    Runnable runnable = future.get();
                    PathTask task = runnable instanceof PathTask ? (PathTask)runnable : null;
                    this.updateMonitor(task);
                }
                this.pendingTasks.remove(future);
            }
            if (this.monitor != null) {
                this.monitor.pluginCompleted("");
            }
        }
        catch (InterruptedException e) {
            logger.error("Plugin interrupted: {}", (Object)e.getMessage(), (Object)e);
            this.monitor.pluginCompleted("Completed with error " + e.getMessage());
        }
        catch (ExecutionException e) {
            logger.error("Error running plugin: {}", (Object)e.getMessage(), (Object)e);
            if (this.pool != null) {
                this.pool.shutdownNow();
            }
            this.monitor.pluginCompleted("Completed with error " + e.getMessage());
        }
        catch (Exception e) {
            logger.error("Error running plugin: {}", (Object)e.getMessage(), (Object)e);
            if (this.pool != null) {
                this.pool.shutdownNow();
            }
            this.monitor.pluginCompleted("Completed with error " + e.getMessage());
        }
        finally {
            this.pendingTasks.clear();
        }
    }

    protected void postProcess(Collection<? extends PathTask> tasks) {
        boolean wasCancelled = this.tasksCancelled || this.monitor.cancelled();
        for (PathTask pathTask : tasks) {
            pathTask.taskComplete(wasCancelled);
        }
    }

    private void updateMonitor(PathTask task) {
        if (this.monitor == null) {
            return;
        }
        String text = task == null ? "Completed" : task.getLastResultsDescription();
        this.monitor.updateProgress(1, text, null);
    }

    @Override
    public boolean isCancelled() {
        return this.tasksCancelled;
    }
}

