/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.plugins;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.images.ImageData;
import qupath.lib.objects.PathObject;
import qupath.lib.plugins.PathPlugin;
import qupath.lib.plugins.TaskRunner;
import qupath.lib.plugins.workflow.SimplePluginWorkflowStep;

public abstract class AbstractPlugin<T>
implements PathPlugin<T> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractPlugin.class);

    protected Collection<Runnable> getTasks(ImageData<T> imageData) {
        Collection<PathObject> parentObjects = this.getParentObjects(imageData);
        if (parentObjects == null || parentObjects.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Runnable> tasks = new ArrayList<Runnable>(parentObjects.size());
        long startTime = System.currentTimeMillis();
        for (PathObject pathObject : parentObjects) {
            this.addRunnableTasks(imageData, pathObject, tasks);
        }
        long endTime = System.currentTimeMillis();
        logger.debug("Time to add plugin tasks: {} ms", (Object)(endTime - startTime));
        return tasks;
    }

    protected boolean requestHierarchyUpdate() {
        return true;
    }

    protected abstract boolean parseArgument(ImageData<T> var1, String var2);

    protected abstract Collection<? extends PathObject> getParentObjects(ImageData<T> var1);

    protected abstract void addRunnableTasks(ImageData<T> var1, PathObject var2, List<Runnable> var3);

    @Override
    public boolean runPlugin(TaskRunner taskRunner, ImageData<T> imageData, String arg) {
        if (!this.parseArgument(imageData, arg)) {
            return false;
        }
        this.preprocess(taskRunner, imageData);
        Collection<Runnable> tasks = this.getTasks(imageData);
        if (tasks.isEmpty()) {
            return false;
        }
        taskRunner.runTasks(tasks);
        if (this.requestHierarchyUpdate()) {
            imageData.getHierarchy().fireHierarchyChangedEvent(this);
        }
        this.postprocess(taskRunner, imageData);
        if (taskRunner.isCancelled()) {
            return false;
        }
        this.addWorkflowStep(imageData, arg);
        return true;
    }

    protected void preprocess(TaskRunner taskRunner, ImageData<T> imageData) {
    }

    protected void postprocess(TaskRunner taskRunner, ImageData<T> imageData) {
    }

    protected void addWorkflowStep(ImageData<T> imageData, String arg) {
        SimplePluginWorkflowStep step = new SimplePluginWorkflowStep(this.getName(), this.getClass(), arg);
        imageData.getHistoryWorkflow().addStep(step);
        logger.debug("Adding workflow step: {}", (Object)step);
    }

    protected static <T> boolean rearrangeByStride(Collection<T> input, T[] output, int stride) {
        int n = input.size();
        int ind = 0;
        int startInd = 0;
        int indNew = 0;
        for (T t : input) {
            if (output[indNew] != null) {
                logger.error("Not null for " + indNew + " (" + ind + "/" + n + ")");
                return false;
            }
            output[indNew] = t;
            ++ind;
            if ((indNew += stride) < n) continue;
            indNew = ++startInd;
        }
        return true;
    }
}

