/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.plugins;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import qupath.lib.images.ImageData;
import qupath.lib.objects.PathAnnotationObject;
import qupath.lib.objects.PathObject;
import qupath.lib.objects.PathObjectTools;
import qupath.lib.objects.TMACoreObject;
import qupath.lib.objects.hierarchy.PathObjectHierarchy;
import qupath.lib.plugins.AbstractInteractivePlugin;

public abstract class AbstractDetectionPlugin<T>
extends AbstractInteractivePlugin<T> {
    @Override
    public Collection<Class<? extends PathObject>> getSupportedParentObjectClasses() {
        return Arrays.asList(PathAnnotationObject.class, TMACoreObject.class);
    }

    @Override
    protected Collection<? extends PathObject> getParentObjects(ImageData<T> imageData) {
        Collection<Class<? extends PathObject>> supported = this.getSupportedParentObjectClasses();
        PathObjectHierarchy hierarchy = imageData.getHierarchy();
        Set<PathObject> selectedObjects = hierarchy.getSelectionModel().getSelectedObjects();
        Collection<? extends PathObject> objects = PathObjectTools.getSupportedObjects(selectedObjects, supported);
        if (!objects.isEmpty() && selectedObjects.size() > objects.size()) {
            HashSet<PathObject> objectsToDeselect = new HashSet<PathObject>(selectedObjects);
            objectsToDeselect.removeAll(objects);
            hierarchy.getSelectionModel().deselectObjects(objectsToDeselect);
        }
        return objects;
    }
}

