/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.objects.utils;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateSequenceFilter;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.index.SpatialIndex;
import org.locationtech.jts.index.hprtree.HPRtree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.objects.PathObject;
import qupath.lib.objects.PathObjectTools;
import qupath.lib.objects.PathObjects;
import qupath.lib.objects.utils.MeasurementStrategy;
import qupath.lib.objects.utils.ObjectProcessor;
import qupath.lib.roi.GeometryTools;
import qupath.lib.roi.RoiTools;
import qupath.lib.roi.interfaces.ROI;

public class ObjectMerger
implements ObjectProcessor {
    private static final Logger logger = LoggerFactory.getLogger(ObjectMerger.class);
    private final BiPredicate<PathObject, PathObject> compatibilityTest;
    private final BiPredicate<Geometry, Geometry> mergeTest;
    private final double searchDistance;
    private final MeasurementStrategy measurementStrategy;

    private ObjectMerger(BiPredicate<PathObject, PathObject> compatibilityTest, BiPredicate<Geometry, Geometry> mergeTest, double searchDistance) {
        this(compatibilityTest, mergeTest, searchDistance, MeasurementStrategy.IGNORE);
    }

    private ObjectMerger(BiPredicate<PathObject, PathObject> compatibilityTest, BiPredicate<Geometry, Geometry> mergeTest, double searchDistance, MeasurementStrategy measurementStrategy) {
        this.compatibilityTest = compatibilityTest;
        this.mergeTest = mergeTest;
        this.searchDistance = searchDistance;
        this.measurementStrategy = measurementStrategy;
    }

    @Deprecated
    public List<PathObject> merge(Collection<? extends PathObject> pathObjects) {
        return this.process(pathObjects);
    }

    @Override
    public List<PathObject> process(Collection<? extends PathObject> pathObjects) {
        boolean doRecursive;
        if (pathObjects == null || pathObjects.isEmpty()) {
            return Collections.emptyList();
        }
        if (pathObjects.size() == 1) {
            return new ArrayList<PathObject>(pathObjects);
        }
        boolean bl = doRecursive = this.useSearchDistance() && System.getProperty("qupath.merge.recursive", "false").equalsIgnoreCase("true");
        if (doRecursive) {
            logger.warn("Using recursive merging!");
        }
        List<List<PathObject>> clustersToMerge = doRecursive ? this.computeClustersRecursive(pathObjects) : this.computeClustersIterative(pathObjects);
        List<PathObject> output = ((Stream)clustersToMerge.stream().parallel()).map(pathObjects1 -> ObjectMerger.mergeObjects(pathObjects1, this.measurementStrategy)).toList();
        assert (output.size() <= pathObjects.size());
        return output;
    }

    public static ObjectMerger createSharedTileBoundaryMerger(double sharedBoundaryThreshold, MeasurementStrategy measurementStrategy) {
        return ObjectMerger.createSharedTileBoundaryMerger(sharedBoundaryThreshold, 0.125, measurementStrategy);
    }

    public static ObjectMerger createSharedTileBoundaryMerger(double sharedBoundaryThreshold) {
        return ObjectMerger.createSharedTileBoundaryMerger(sharedBoundaryThreshold, 0.125, MeasurementStrategy.IGNORE);
    }

    public static ObjectMerger createSharedTileBoundaryMerger(double sharedBoundaryThreshold, double overlapTolerance, MeasurementStrategy measurementStrategy) {
        return new ObjectMerger(ObjectMerger::sameClassTypePlaneTest, ObjectMerger.createBoundaryOverlapTest(sharedBoundaryThreshold, overlapTolerance), 0.0625, measurementStrategy);
    }

    public static ObjectMerger createSharedTileBoundaryMerger(double sharedBoundaryThreshold, double overlapTolerance) {
        return ObjectMerger.createSharedTileBoundaryMerger(sharedBoundaryThreshold, overlapTolerance, MeasurementStrategy.IGNORE);
    }

    public static ObjectMerger createSharedClassificationMerger(MeasurementStrategy measurementStrategy) {
        return new ObjectMerger(ObjectMerger::sameClassTypePlaneTest, ObjectMerger::sameDimensions, -1.0, measurementStrategy);
    }

    public static ObjectMerger createSharedClassificationMerger() {
        return ObjectMerger.createSharedClassificationMerger(MeasurementStrategy.IGNORE);
    }

    public static ObjectMerger createTouchingMerger(MeasurementStrategy measurementStrategy) {
        return new ObjectMerger(ObjectMerger::sameClassTypePlaneTest, ObjectMerger::sameDimensionsAndTouching, 0.0, measurementStrategy);
    }

    public static ObjectMerger createTouchingMerger() {
        return ObjectMerger.createTouchingMerger(MeasurementStrategy.IGNORE);
    }

    public static ObjectMerger createIoUMerger(double iouThreshold, MeasurementStrategy measurementStrategy) {
        return new ObjectMerger(ObjectMerger::sameClassTypePlaneTest, ObjectMerger.createIoUMergeTest(iouThreshold), 0.0625, measurementStrategy);
    }

    public static ObjectMerger createIoUMerger(double iouThreshold) {
        return ObjectMerger.createIoUMerger(iouThreshold, MeasurementStrategy.IGNORE);
    }

    public static ObjectMerger createIoMinMerger(double iomThreshold, MeasurementStrategy measurementStrategy) {
        return new ObjectMerger(ObjectMerger::sameClassTypePlaneTest, ObjectMerger.createIoMinMergeTest(iomThreshold), 0.0625, measurementStrategy);
    }

    public static ObjectMerger createIoMinMerger(double iomThreshold) {
        return ObjectMerger.createIoMinMerger(iomThreshold, MeasurementStrategy.IGNORE);
    }

    private List<List<PathObject>> computeClustersRecursive(Collection<? extends PathObject> allObjects) {
        ArrayList<List<PathObject>> clusters = new ArrayList<List<PathObject>>();
        HashSet<PathObject> alreadyVisited = new HashSet<PathObject>();
        Map<ROI, Geometry> geometryMap = ObjectMerger.buildMutableGeometryMap(allObjects);
        SpatialIndex index = ObjectMerger.buildSpatialIndex(allObjects, geometryMap);
        for (PathObject pathObject : allObjects) {
            if (alreadyVisited.contains(pathObject)) continue;
            List<PathObject> cluster = this.addMergesRecursive(pathObject, new ArrayList<PathObject>(), alreadyVisited, index, geometryMap);
            if (cluster.isEmpty()) {
                logger.warn("Empty cluster - this is unexpected!");
                continue;
            }
            clusters.add(cluster);
        }
        return clusters;
    }

    private List<List<PathObject>> computeClustersIterative(Collection<? extends PathObject> allObjects) {
        Map<ROI, Geometry> geometryMap = ObjectMerger.buildMutableGeometryMap(allObjects);
        SpatialIndex index = ObjectMerger.buildSpatialIndex(allObjects, geometryMap);
        ArrayList<List<PathObject>> clusters = new ArrayList<List<PathObject>>();
        HashSet<PathObject> alreadyVisited = new HashSet<PathObject>();
        ArrayDeque<PathObject> pending = new ArrayDeque<PathObject>();
        for (PathObject pathObject : allObjects) {
            if (alreadyVisited.contains(pathObject)) continue;
            ArrayList<PathObject> cluster = new ArrayList<PathObject>();
            pending.clear();
            pending.add(pathObject);
            while (!pending.isEmpty()) {
                PathObject current = (PathObject)pending.poll();
                if (!alreadyVisited.add(current)) continue;
                cluster.add(current);
                if (pathObject != current && !this.useSearchDistance()) continue;
                Geometry currentGeometry = this.getGeometry(current, geometryMap);
                Collection<? extends PathObject> allPotentialNeighbors = this.useSearchDistance() ? this.findCompatibleNeighbors(currentGeometry, index) : allObjects;
                List<PathObject> neighbors = this.filterCompatibleNeighbors(current, allPotentialNeighbors);
                List<PathObject> addable = neighbors.stream().filter(neighbor -> !alreadyVisited.contains(neighbor)).toList();
                addable = addable.parallelStream().filter(neighbor -> this.mergeTest.test(currentGeometry, this.getGeometry((PathObject)neighbor, geometryMap))).toList();
                pending.addAll(addable);
            }
            if (cluster.isEmpty()) {
                logger.warn("Empty cluster - this is unexpected!");
                continue;
            }
            clusters.add(cluster);
        }
        return clusters;
    }

    private List<PathObject> addMergesRecursive(PathObject pathObject, List<PathObject> currentCluster, Set<PathObject> alreadyVisited, SpatialIndex index, Map<ROI, Geometry> geometryMap) throws UnsupportedOperationException {
        if (!alreadyVisited.add(pathObject)) {
            return currentCluster;
        }
        currentCluster.add(pathObject);
        if (!this.useSearchDistance()) {
            throw new UnsupportedOperationException("Recursive merging requires a search distance");
        }
        List<PathObject> neighbors = this.findCompatibleNeighbors(this.getGeometry(pathObject, geometryMap), index);
        for (PathObject neighbor : neighbors) {
            if (alreadyVisited.contains(neighbor) || !this.mergeTest.test(this.getGeometry(pathObject, geometryMap), this.getGeometry(neighbor, geometryMap))) continue;
            this.addMergesRecursive(neighbor, currentCluster, alreadyVisited, index, geometryMap);
        }
        return currentCluster;
    }

    private boolean useSearchDistance() {
        return this.searchDistance >= 0.0 && this.searchDistance < Double.MAX_VALUE && Double.isFinite(this.searchDistance);
    }

    private List<PathObject> findCompatibleNeighbors(Geometry geometry, SpatialIndex index) {
        Envelope envelopeQuery = geometry.getEnvelopeInternal();
        double expansion = 1.0E-6;
        envelopeQuery.expandBy(expansion);
        return index.query(envelopeQuery);
    }

    private List<PathObject> filterCompatibleNeighbors(PathObject pathObject, Collection<? extends PathObject> potentialNeighbors) {
        return ObjectMerger.filterCompatibleNeighbors(pathObject, potentialNeighbors, this.compatibilityTest);
    }

    private static List<PathObject> filterCompatibleNeighbors(PathObject pathObject, Collection<? extends PathObject> potentialNeighbors, BiPredicate<PathObject, PathObject> compatibilityTest) {
        return potentialNeighbors.stream().filter(p -> compatibilityTest.test(pathObject, (PathObject)p)).map(p -> p).toList();
    }

    private Geometry getGeometry(PathObject pathObject, Map<ROI, Geometry> geometryMap) {
        return geometryMap.computeIfAbsent(pathObject.getROI(), ROI::getGeometry);
    }

    private static BiPredicate<Geometry, Geometry> createIoUMergeTest(double iouThreshold) {
        return (geom, geomOverlap) -> {
            Geometry i = geom.intersection(geomOverlap);
            double intersection = i.getArea();
            double union = geom.getArea() + geomOverlap.getArea() - intersection;
            if (union == 0.0) {
                return false;
            }
            return intersection / union >= iouThreshold;
        };
    }

    private static BiPredicate<Geometry, Geometry> createIoMinMergeTest(double iomThreshold) {
        return (geom, geomOverlap) -> {
            double minArea = Math.min(geom.getArea(), geomOverlap.getArea());
            if (minArea == 0.0) {
                return false;
            }
            Geometry i = geom.intersection(geomOverlap);
            double intersection = i.getArea();
            return intersection / minArea >= iomThreshold;
        };
    }

    private static boolean sameDimensionsAndTouching(Geometry geom, Geometry geom2) {
        return ObjectMerger.sameDimensions(geom, geom2) && geom.touches(geom2);
    }

    private static boolean sameDimensions(Geometry geom, Geometry geom2) {
        return geom.getDimension() == geom2.getDimension();
    }

    private static BiPredicate<Geometry, Geometry> createBoundaryOverlapTest(double sharedBoundaryThreshold, double pixelOverlapTolerance) {
        return (geom, geomOverlap) -> {
            if (ObjectMerger.calculateUpperLowerSharedBoundaryIntersectionScore(geom, geomOverlap, pixelOverlapTolerance) >= sharedBoundaryThreshold) {
                return true;
            }
            if (ObjectMerger.calculateLeftRightSharedBoundaryIntersectionScore(geom, geomOverlap, pixelOverlapTolerance) >= sharedBoundaryThreshold) {
                return true;
            }
            if (ObjectMerger.calculateUpperLowerSharedBoundaryIntersectionScore(geomOverlap, geom, pixelOverlapTolerance) >= sharedBoundaryThreshold) {
                return true;
            }
            return ObjectMerger.calculateLeftRightSharedBoundaryIntersectionScore(geomOverlap, geom, pixelOverlapTolerance) >= sharedBoundaryThreshold;
        };
    }

    private static SpatialIndex buildSpatialIndex(Collection<? extends PathObject> pathObjects, Map<ROI, Geometry> geometryMap) {
        HPRtree index = new HPRtree();
        ObjectMerger.populateSpatialIndex((SpatialIndex)index, pathObjects, geometryMap);
        return index;
    }

    private static void populateSpatialIndex(SpatialIndex tree, Collection<? extends PathObject> pathObjects, Map<ROI, Geometry> geometryMap) {
        for (PathObject pathObject : pathObjects) {
            Geometry geom = geometryMap.getOrDefault(pathObject.getROI(), null);
            if (geom == null) continue;
            Envelope envelope = geom.getEnvelopeInternal();
            tree.insert(envelope, (Object)pathObject);
        }
    }

    private static boolean sameClassTypePlaneTest(PathObject first, PathObject second) {
        return second != first && Objects.equals(first.getPathClass(), second.getPathClass()) && Objects.equals(first.getROI().getImagePlane(), second.getROI().getImagePlane()) && Objects.equals(first.getClass(), second.getClass());
    }

    private static Map<ROI, Geometry> buildMutableGeometryMap(Collection<? extends PathObject> pathObjects) {
        ConcurrentMap map = pathObjects.parallelStream().filter(PathObject::hasROI).map(PathObject::getROI).distinct().collect(Collectors.toConcurrentMap(Function.identity(), ROI::getGeometry));
        return new ConcurrentHashMap<ROI, Geometry>(map);
    }

    private static PathObject mergeObjects(List<? extends PathObject> pathObjects, MeasurementStrategy measurementStrategy) {
        if (pathObjects.isEmpty()) {
            return null;
        }
        PathObject pathObject = pathObjects.getFirst();
        if (pathObjects.size() == 1) {
            return pathObject;
        }
        List allROIs = pathObjects.stream().map(PathObject::getROI).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        ROI mergedROI = RoiTools.union(allROIs);
        PathObject mergedObject = null;
        if (pathObject.isTile()) {
            mergedObject = PathObjects.createTileObject(mergedROI, pathObject.getPathClass());
        } else if (pathObject.isCell()) {
            List nucleusROIs = pathObjects.stream().map(PathObjectTools::getNucleusROI).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            ROI nucleusROI = nucleusROIs.isEmpty() ? null : RoiTools.union(nucleusROIs);
            mergedObject = PathObjects.createCellObject(mergedROI, nucleusROI, pathObject.getPathClass());
        } else if (pathObject.isDetection()) {
            mergedObject = PathObjects.createDetectionObject(mergedROI, pathObject.getPathClass());
        } else if (pathObject.isAnnotation()) {
            mergedObject = PathObjects.createAnnotationObject(mergedROI, pathObject.getPathClass());
        } else {
            throw new IllegalArgumentException("Unsupported object type for merging: " + String.valueOf(pathObject.getClass()));
        }
        measurementStrategy.mergeMeasurements(pathObjects, mergedObject.getMeasurementList());
        Integer color = pathObject.getColor();
        if (color != null) {
            mergedObject.setColor(color);
        }
        return mergedObject;
    }

    private static double calculateUpperLowerSharedBoundaryIntersectionScore(Geometry upper, Geometry lower, double overlapTolerance) {
        Envelope envUpper = upper.getEnvelopeInternal();
        Envelope envLower = lower.getEnvelopeInternal();
        if (envUpper.getMaxY() >= envLower.getMinY() && Math.abs(envUpper.getMaxY() - envLower.getMinY()) < overlapTolerance) {
            double lowerLength;
            Geometry upperIntersection = ObjectMerger.createEnvelopeIntersection(upper, envUpper.getMinX(), envUpper.getMaxY(), envUpper.getMaxX(), envUpper.getMaxY());
            Geometry lowerIntersection = ObjectMerger.createEnvelopeIntersection(lower, envLower.getMinX(), envLower.getMinY(), envLower.getMaxX(), envLower.getMinY());
            double upperLength = upperIntersection.getLength();
            if (Math.min(upperLength, lowerLength = lowerIntersection.getLength()) <= 0.0) {
                return 0.0;
            }
            if (envUpper.getMaxY() != envLower.getMinY()) {
                lowerIntersection.apply((CoordinateSequenceFilter)new SetOrdinateFilter(1, envUpper.getMaxY()));
            }
            lowerIntersection = GeometryTools.homogenizeGeometryCollection(lowerIntersection);
            upperIntersection = GeometryTools.homogenizeGeometryCollection(upperIntersection);
            Geometry sharedIntersection = upperIntersection.intersection(lowerIntersection);
            double intersectionLength = sharedIntersection.getLength();
            return intersectionLength / (upperLength + lowerLength - intersectionLength);
        }
        return 0.0;
    }

    private static double calculateLeftRightSharedBoundaryIntersectionScore(Geometry left, Geometry right, double overlapTolerance) {
        Envelope envLeft = left.getEnvelopeInternal();
        Envelope envRight = right.getEnvelopeInternal();
        if (envLeft.getMaxX() >= envRight.getMinX() && Math.abs(envLeft.getMaxX() - envRight.getMinX()) < overlapTolerance) {
            double rightLength;
            Geometry leftIntersection = ObjectMerger.createEnvelopeIntersection(left, envLeft.getMaxX(), envLeft.getMinY(), envLeft.getMaxX(), envLeft.getMaxY());
            Geometry rightIntersection = ObjectMerger.createEnvelopeIntersection(right, envRight.getMinX(), envRight.getMinY(), envRight.getMinX(), envRight.getMaxY());
            double leftLength = leftIntersection.getLength();
            if (Math.min(leftLength, rightLength = rightIntersection.getLength()) <= 0.0) {
                return 0.0;
            }
            if (envLeft.getMaxX() != envRight.getMinX()) {
                rightIntersection.apply((CoordinateSequenceFilter)new SetOrdinateFilter(1, envLeft.getMaxY()));
            }
            leftIntersection = GeometryTools.homogenizeGeometryCollection(leftIntersection);
            rightIntersection = GeometryTools.homogenizeGeometryCollection(rightIntersection);
            Geometry sharedIntersection = rightIntersection.intersection(leftIntersection);
            double intersectionLength = sharedIntersection.getLength();
            return intersectionLength / (rightLength + leftLength - intersectionLength);
        }
        return 0.0;
    }

    private static Geometry createEnvelopeIntersection(Geometry geom, double x1, double y1, double x2, double y2) {
        GeometryFactory factory = geom.getFactory();
        LineString line = ObjectMerger.createLine(factory, x1, y1, x2, y2);
        return geom.intersection((Geometry)line);
    }

    private static LineString createLine(GeometryFactory factory, double x1, double y1, double x2, double y2) {
        return factory.createLineString(new Coordinate[]{new Coordinate(x1, y1), new Coordinate(x2, y2)});
    }

    private static class SetOrdinateFilter
    implements CoordinateSequenceFilter {
        private final int ordinateIndex;
        private final double value;

        SetOrdinateFilter(int ordinateIndex, double value) {
            this.ordinateIndex = ordinateIndex;
            this.value = value;
        }

        public void filter(CoordinateSequence seq, int i) {
            seq.setOrdinate(i, this.ordinateIndex, this.value);
        }

        public boolean isDone() {
            return false;
        }

        public boolean isGeometryChanged() {
            return false;
        }
    }
}

