/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.objects.utils;

import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.measurements.MeasurementList;
import qupath.lib.objects.PathObject;

@FunctionalInterface
public interface MeasurementStrategy {
    public static final MeasurementStrategy IGNORE = (pathObjects, outputList) -> {};
    public static final MeasurementStrategy USE_FIRST = (pathObjects, outputList) -> {
        if (pathObjects.isEmpty()) {
            return;
        }
        outputList.putAll(((PathObject)pathObjects.getFirst()).getMeasurementList());
    };
    public static final MeasurementStrategy MEAN = (pathObjects, outputList) -> {
        if (pathObjects.size() <= 1) {
            USE_FIRST.mergeMeasurements(pathObjects, outputList);
            return;
        }
        for (String name : ((PathObject)pathObjects.getFirst()).getMeasurementList().getNames()) {
            outputList.put(name, pathObjects.stream().mapToDouble(po -> po.getMeasurementList().get(name)).average().orElse(Double.NaN));
        }
    };
    public static final MeasurementStrategy WEIGHTED_MEAN = (pathObjects, outputList) -> {
        if (pathObjects.size() <= 1) {
            USE_FIRST.mergeMeasurements(pathObjects, outputList);
            return;
        }
        Map<PathObject, Double> weights = MeasurementStrategy.computeAreaWeights(pathObjects);
        for (String name : ((PathObject)pathObjects.getFirst()).getMeasurementList().getNames()) {
            outputList.put(name, pathObjects.stream().mapToDouble(po -> po.getMeasurementList().get(name) * (Double)weights.get(po)).sum());
        }
    };
    public static final MeasurementStrategy MEDIAN = (pathObjects, outputList) -> {
        if (pathObjects.size() <= 1) {
            USE_FIRST.mergeMeasurements(pathObjects, outputList);
            return;
        }
        for (String name : ((PathObject)pathObjects.getFirst()).getMeasurementList().getNames()) {
            outputList.put(name, pathObjects.stream().mapToDouble(po -> po.getMeasurementList().get(name)).sorted().skip((pathObjects.size() - 1) / 2).limit(2 - pathObjects.size() % 2).average().orElse(Double.NaN));
        }
    };
    public static final MeasurementStrategy RANDOM = (pathObjects, outputList) -> {
        if (pathObjects.size() <= 1) {
            USE_FIRST.mergeMeasurements(pathObjects, outputList);
            return;
        }
        MeasurementList chosen = pathObjects.stream().skip((int)((double)pathObjects.size() * Math.random())).findFirst().map(PathObject::getMeasurementList).orElse(null);
        if (chosen == null) {
            return;
        }
        outputList.putAll(chosen);
    };
    public static final MeasurementStrategy USE_BIGGEST = (pathObjects, outputList) -> {
        if (pathObjects.size() <= 1) {
            USE_FIRST.mergeMeasurements(pathObjects, outputList);
            return;
        }
        MeasurementList chosen = pathObjects.stream().max(Comparator.comparingDouble(p -> p.getROI().getArea()).thenComparing(p -> p.getROI().getLength()).thenComparing(p -> p.getROI().getNumPoints())).map(PathObject::getMeasurementList).orElse(null);
        if (chosen.isEmpty()) {
            return;
        }
        outputList.putAll(chosen);
    };
    public static final MeasurementStrategy MAX = (pathObjects, outputList) -> {
        if (pathObjects.size() <= 1) {
            USE_FIRST.mergeMeasurements(pathObjects, outputList);
            return;
        }
        for (String name : ((PathObject)pathObjects.getFirst()).getMeasurementList().getNames()) {
            outputList.put(name, pathObjects.stream().mapToDouble(po -> po.getMeasurementList().get(name)).max().orElse(Double.NaN));
        }
    };
    public static final MeasurementStrategy MIN = (pathObjects, outputList) -> {
        if (pathObjects.size() <= 1) {
            USE_FIRST.mergeMeasurements(pathObjects, outputList);
            return;
        }
        for (String name : ((PathObject)pathObjects.getFirst()).getMeasurementList().getNames()) {
            outputList.put(name, pathObjects.stream().mapToDouble(po -> po.getMeasurementList().get(name)).min().orElse(Double.NaN));
        }
    };

    public void mergeMeasurements(List<? extends PathObject> var1, MeasurementList var2);

    private static Map<PathObject, Double> computeAreaWeights(List<? extends PathObject> pathObjects) {
        HashMap<PathObject, Double> output = new HashMap<PathObject, Double>();
        double sum = 0.0;
        for (PathObject pathObject : pathObjects) {
            double area = pathObject.getROI().getArea();
            sum += area;
            output.put(pathObject, area);
        }
        if (sum == 0.0) {
            Logger logger = LoggerFactory.getLogger(MeasurementStrategy.class);
            logger.warn("No object has non-zero area");
        }
        for (PathObject pathObject : output.keySet()) {
            double finalSum = sum;
            output.computeIfPresent(pathObject, (k, value) -> value / finalSum);
        }
        return output;
    }
}

