/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.objects.hierarchy.events;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import qupath.lib.objects.PathObject;
import qupath.lib.objects.hierarchy.PathObjectHierarchy;

public class PathObjectHierarchyEvent {
    private Object source;
    private PathObjectHierarchy hierarchy;
    private PathObject parentObject;
    private HierarchyEventType type;
    private List<PathObject> pathObjects;
    private boolean isChanging;
    private long timestamp;

    PathObjectHierarchyEvent(Object source, PathObjectHierarchy hierarchy, HierarchyEventType type, PathObject parentObject, List<PathObject> pathObjects, boolean isChanging) {
        this.source = source;
        this.hierarchy = hierarchy;
        this.type = type;
        this.parentObject = parentObject;
        this.pathObjects = Collections.unmodifiableList(pathObjects);
        this.isChanging = isChanging;
    }

    public String toString() {
        return "Hierarchy change event: Source=" + String.valueOf(this.source) + ", Type=" + String.valueOf((Object)this.type) + ", Parent=" + String.valueOf(this.parentObject);
    }

    public static PathObjectHierarchyEvent createStructureChangeEvent(Object source, PathObjectHierarchy hierarchy, PathObject parentObject) {
        return new PathObjectHierarchyEvent(source, hierarchy, HierarchyEventType.OTHER_STRUCTURE_CHANGE, parentObject, new ArrayList<PathObject>(0), false);
    }

    public static PathObjectHierarchyEvent createObjectAddedEvent(Object source, PathObjectHierarchy hierarchy, PathObject parentObject, PathObject pathObjectAdded) {
        return new PathObjectHierarchyEvent(source, hierarchy, HierarchyEventType.ADDED, parentObject, Collections.singletonList(pathObjectAdded), false);
    }

    public static PathObjectHierarchyEvent createObjectRemovedEvent(Object source, PathObjectHierarchy hierarchy, PathObject parentObject, PathObject pathObjectRemoved) {
        return new PathObjectHierarchyEvent(source, hierarchy, HierarchyEventType.REMOVED, parentObject, Collections.singletonList(pathObjectRemoved), false);
    }

    public static PathObjectHierarchyEvent createObjectsChangedEvent(Object source, PathObjectHierarchy hierarchy, HierarchyEventType type, Collection<? extends PathObject> pathObjects, boolean isChanging) {
        return new PathObjectHierarchyEvent(source, hierarchy, type, null, new ArrayList<PathObject>(pathObjects), isChanging);
    }

    public boolean isChanging() {
        return this.isChanging;
    }

    public PathObjectHierarchy getHierarchy() {
        return this.hierarchy;
    }

    public List<PathObject> getChangedObjects() {
        return this.pathObjects;
    }

    public HierarchyEventType getEventType() {
        return this.type;
    }

    public Object getSource() {
        return this.source;
    }

    public boolean isStructureChangeEvent() {
        return this.isAddedOrRemovedEvent() || this.type == HierarchyEventType.OTHER_STRUCTURE_CHANGE;
    }

    public boolean isAddedOrRemovedEvent() {
        return this.type == HierarchyEventType.ADDED || this.type == HierarchyEventType.REMOVED;
    }

    public boolean isObjectClassificationEvent() {
        return this.type == HierarchyEventType.CHANGE_CLASSIFICATION;
    }

    public boolean isObjectMeasurementEvent() {
        return this.type == HierarchyEventType.CHANGE_MEASUREMENTS;
    }

    public PathObject getStructureChangeBase() {
        if (this.isStructureChangeEvent()) {
            return this.parentObject;
        }
        return null;
    }

    public static enum HierarchyEventType {
        ADDED,
        REMOVED,
        OTHER_STRUCTURE_CHANGE,
        CHANGE_CLASSIFICATION,
        CHANGE_MEASUREMENTS,
        CHANGE_OTHER;

    }
}

