/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.objects.hierarchy;

import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import org.locationtech.jts.algorithm.construct.MaximumInscribedCircle;
import org.locationtech.jts.algorithm.distance.DiscreteHausdorffDistance;
import org.locationtech.jts.algorithm.locate.IndexedPointInAreaLocator;
import org.locationtech.jts.algorithm.locate.PointOnGeometryLocator;
import org.locationtech.jts.algorithm.locate.SimplePointInAreaLocator;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Polygonal;
import org.locationtech.jts.geom.prep.PreparedGeometry;
import org.locationtech.jts.geom.prep.PreparedGeometryFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.roi.interfaces.ROI;

class RoiRelate {
    private static final Logger logger = LoggerFactory.getLogger(RoiRelate.class);
    private final ROI roi;
    private final Geometry geometry;
    private final double area;
    private final double tolerance;
    private final double minBoundsX;
    private final double minBoundsY;
    private final double maxBoundsX;
    private final double maxBoundsY;
    private volatile PreparedGeometry preparedGeometry;
    private volatile PointOnGeometryLocator locator;
    private final Map<ROI, Boolean> coversMap = Collections.synchronizedMap(new WeakHashMap());

    RoiRelate(ROI roi, Geometry geometry) {
        this.roi = roi;
        this.geometry = geometry == null ? roi.getGeometry() : geometry;
        this.area = roi.getArea();
        this.tolerance = Math.max(0.001, 2.0 / this.geometry.getFactory().getPrecisionModel().getScale());
        this.minBoundsX = roi.getBoundsX() - this.tolerance;
        this.minBoundsY = roi.getBoundsY() - this.tolerance;
        this.maxBoundsX = roi.getBoundsX() + roi.getBoundsWidth() + this.tolerance;
        this.maxBoundsY = roi.getBoundsY() + roi.getBoundsHeight() + this.tolerance;
    }

    public boolean coversWithTolerance(ROI roi) {
        if (this.samePlane(roi) && this.boundsCovers(roi) && this.area >= roi.getArea()) {
            return this.coversMap.computeIfAbsent(roi, this::computeCoversWithTolerance);
        }
        return false;
    }

    private boolean boundsCovers(ROI roi) {
        return this.minBoundsX <= roi.getBoundsX() && this.minBoundsY <= roi.getBoundsY() && this.maxBoundsX >= roi.getBoundsX() + roi.getBoundsWidth() && this.maxBoundsY >= roi.getBoundsY() + roi.getBoundsHeight();
    }

    private boolean samePlane(ROI roi) {
        return this.roi.getZ() == roi.getZ() && this.roi.getT() == roi.getT();
    }

    private boolean computeCoversWithTolerance(ROI roi) {
        double childArea;
        Geometry child = roi.getGeometry();
        if (child.isEmpty()) {
            return false;
        }
        PreparedGeometry parent = this.getPreparedGeometry();
        if (parent.covers(child)) {
            return true;
        }
        if (parent.disjoint(child) || parent.touches(child)) {
            return false;
        }
        double parentArea = parent.getGeometry().getArea();
        if (parentArea < (childArea = child.getArea()) || childArea == 0.0) {
            return false;
        }
        Envelope env = parent.getGeometry().getEnvelopeInternal();
        env.expandBy(this.tolerance);
        if (!env.covers(child.getEnvelopeInternal())) {
            return false;
        }
        Geometry diff = child.difference(parent.getGeometry());
        if (diff.isEmpty()) {
            logger.trace("Geometry covers - difference is empty");
            return true;
        }
        MaximumInscribedCircle maximumInscribedCircle = new MaximumInscribedCircle(diff, this.tolerance / 10.0);
        if (maximumInscribedCircle.getRadiusLine().getLength() * 2.0 >= this.tolerance) {
            logger.trace("Geometry does not cover - fails max inscribed circle test");
            return false;
        }
        Geometry intersection = parent.getGeometry().intersection(child);
        double actualDist = DiscreteHausdorffDistance.distance((Geometry)intersection, (Geometry)child, (double)0.01);
        logger.trace("Applying DiscreteHausdorffDistance test");
        return actualDist < this.tolerance;
    }

    public boolean containsCentroid(ROI roi) {
        if (!this.samePlane(roi)) {
            return false;
        }
        return this.contains(new Coordinate(roi.getCentroidX(), roi.getCentroidY()));
    }

    public boolean contains(double x, double y) {
        Coordinate coord = new Coordinate(x, y);
        if (this.contains(coord)) {
            return true;
        }
        this.geometry.getFactory().getPrecisionModel().makePrecise(coord);
        return this.contains(coord);
    }

    public boolean contains(Coordinate coord) {
        return this.getLocator().locate(coord) != 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PreparedGeometry getPreparedGeometry() {
        if (this.preparedGeometry == null) {
            RoiRelate roiRelate = this;
            synchronized (roiRelate) {
                if (this.preparedGeometry == null) {
                    this.preparedGeometry = PreparedGeometryFactory.prepare((Geometry)this.geometry);
                }
            }
        }
        return this.preparedGeometry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PointOnGeometryLocator getLocator() {
        if (this.locator == null) {
            RoiRelate roiRelate = this;
            synchronized (roiRelate) {
                if (this.locator == null) {
                    this.locator = RoiRelate.createLocator(this.geometry);
                }
            }
        }
        return this.locator;
    }

    private static synchronized PointOnGeometryLocator createLocator(Geometry geometry) {
        Object locator = geometry instanceof Polygonal || geometry instanceof LinearRing ? new IndexedPointInAreaLocator(geometry) : new SimplePointInAreaLocator(geometry);
        locator.locate(new Coordinate());
        return locator;
    }
}

