/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.objects.hierarchy;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.locationtech.jts.algorithm.locate.SimplePointInAreaLocator;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.index.SpatialIndex;
import org.locationtech.jts.index.quadtree.Quadtree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.objects.PathObject;
import qupath.lib.objects.TemporaryObject;
import qupath.lib.objects.hierarchy.PathObjectHierarchy;
import qupath.lib.objects.hierarchy.RoiRelate;
import qupath.lib.objects.hierarchy.events.PathObjectHierarchyEvent;
import qupath.lib.objects.hierarchy.events.PathObjectHierarchyListener;
import qupath.lib.regions.ImageRegion;
import qupath.lib.roi.interfaces.ROI;

class PathObjectTileCache
implements PathObjectHierarchyListener {
    private static final Logger logger = LoggerFactory.getLogger(PathObjectTileCache.class);
    private static final Envelope MAX_ENVELOPE = new Envelope(-1.7976931348623157E308, Double.MAX_VALUE, -1.7976931348623157E308, Double.MAX_VALUE);
    private final Map<Class<? extends PathObject>, SpatialIndex> map = new HashMap<Class<? extends PathObject>, SpatialIndex>();
    private static final Map<ROI, Geometry> geometryMap = Collections.synchronizedMap(new WeakHashMap());
    private static final Map<ROI, RoiRelate> relateMap = Collections.synchronizedMap(new WeakHashMap());
    private final PathObjectHierarchy hierarchy;
    private boolean isActive = false;
    private final ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();
    private final Lock r = this.rwl.readLock();
    private final Lock w = this.rwl.writeLock();

    public PathObjectTileCache(PathObjectHierarchy hierarchy) {
        this.hierarchy = hierarchy;
        if (hierarchy != null) {
            hierarchy.addListener(this);
        }
    }

    public void resetCache() {
        this.isActive = false;
        logger.trace("Cache reset!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void constructCache(Class<? extends PathObject> limitToClass) {
        this.w.lock();
        try {
            long startTime = System.currentTimeMillis();
            this.isActive = true;
            if (limitToClass == null) {
                this.map.clear();
            } else {
                this.map.remove(limitToClass);
            }
            this.addToCache(this.hierarchy.getRootObject(), true, limitToClass);
            long endTime = System.currentTimeMillis();
            logger.debug("Cache reconstructed in {} ms", (Object)(endTime - startTime));
        }
        finally {
            this.w.unlock();
        }
    }

    private void ensureCacheConstructed() {
        if (!this.isActive()) {
            this.constructCache(null);
        }
    }

    public boolean isActive() {
        return this.isActive;
    }

    private void addToCache(PathObject pathObject, boolean includeChildren, Class<? extends PathObject> limitToClass) {
        if (!this.isActive()) {
            return;
        }
        if (pathObject.hasROI()) {
            Class<?> cls = pathObject.getClass();
            if (limitToClass == null || cls == limitToClass) {
                SpatialIndex mapObjects = this.map.computeIfAbsent(cls, k -> this.createSpatialIndex());
                Envelope envelope = this.getEnvelope(pathObject);
                mapObjects.insert(envelope, (Object)pathObject);
            }
        }
        if (includeChildren && !(pathObject instanceof TemporaryObject) && pathObject.hasChildObjects()) {
            for (PathObject child : pathObject.getChildObjectsAsArray()) {
                this.addToCache(child, includeChildren, limitToClass);
            }
        }
    }

    Geometry getGeometry(ROI roi) {
        Geometry geometry = geometryMap.get(roi);
        if (geometry == null) {
            return roi.getGeometry();
        }
        return geometry;
    }

    private Coordinate getCentroidCoordinate(ROI roi) {
        return new Coordinate(roi.getCentroidX(), roi.getCentroidY());
    }

    boolean covers(PathObject possibleParent, PathObject possibleChild) {
        ROI roi = possibleParent.getROI();
        ROI roiChild = possibleChild.getROI();
        if (roi == null || roi.isEmpty() || roiChild == null || roiChild.isEmpty()) {
            return false;
        }
        return this.getRoiRelate(roi).coversWithTolerance(roiChild);
    }

    RoiRelate getRoiRelate(ROI roi) {
        return relateMap.computeIfAbsent(roi, r -> new RoiRelate((ROI)r, this.getGeometry((ROI)r)));
    }

    boolean containsCentroid(PathObject possibleParent, PathObject possibleChild) {
        this.getRoiRelate(possibleParent.getROI());
        return this.containsCentroid(possibleParent.getROI(), possibleChild.getROI());
    }

    private boolean containsCentroid(ROI roi, ROI roiChild) {
        if (roi == null || roi.isEmpty()) {
            return false;
        }
        Coordinate centroid = this.getCentroidCoordinate(roiChild);
        RoiRelate relate = relateMap.getOrDefault(roi, null);
        if (relate != null) {
            return relate.contains(centroid);
        }
        return SimplePointInAreaLocator.locate((Coordinate)centroid, (Geometry)this.getGeometry(roi)) != 2;
    }

    private SpatialIndex createSpatialIndex() {
        return new Quadtree();
    }

    private Envelope getEnvelope(PathObject pathObject) {
        return this.getEnvelope(pathObject.getROI());
    }

    private Envelope getEnvelope(ROI roi) {
        return new Envelope(roi.getBoundsX(), roi.getBoundsX() + roi.getBoundsWidth(), roi.getBoundsY(), roi.getBoundsY() + roi.getBoundsHeight());
    }

    private Envelope getEnvelope(ImageRegion region) {
        return new Envelope((double)region.getMinX(), (double)region.getMaxX(), (double)region.getMinY(), (double)region.getMaxY());
    }

    private void removeFromCache(PathObject pathObject, boolean removeChildren) {
        if (!this.isActive()) {
            return;
        }
        SpatialIndex mapObjects = this.map.get(pathObject.getClass());
        if (mapObjects instanceof Quadtree) {
            if (mapObjects.remove(MAX_ENVELOPE, (Object)pathObject)) {
                logger.debug("Removed {} from cache", (Object)pathObject);
            } else {
                logger.debug("Unable to remove {} from cache", (Object)pathObject);
            }
            if (removeChildren) {
                for (PathObject child : pathObject.getChildObjectsAsArray()) {
                    this.removeFromCache(child, removeChildren);
                }
            }
        } else if (mapObjects != null && !removeChildren) {
            this.constructCache(pathObject.getClass());
        } else {
            this.constructCache(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<PathObject> getObjectsForRegion(Class<? extends PathObject> cls, ImageRegion region, Collection<PathObject> pathObjects, boolean includeSubclasses) {
        this.ensureCacheConstructed();
        Envelope envelope = region == null ? MAX_ENVELOPE : this.getEnvelope(region);
        int z = region == null ? -1 : region.getZ();
        int t = region == null ? -1 : region.getT();
        this.r.lock();
        try {
            Collection<PathObject> collection;
            for (Map.Entry<Class<? extends PathObject>, SpatialIndex> entry : this.map.entrySet()) {
                List list;
                if (cls != null && (!includeSubclasses || !cls.isAssignableFrom(entry.getKey())) && !Objects.equals(cls, entry.getKey()) || entry.getValue() == null || (list = entry.getValue().query(envelope)).isEmpty()) continue;
                if (pathObjects == null) {
                    pathObjects = new HashSet<PathObject>();
                }
                for (PathObject pathObject : list) {
                    ROI roi = pathObject.getROI();
                    if (roi != null && region != null && (roi.getZ() != z || roi.getT() != t) || pathObject.getParent() == null && !pathObject.isRootObject() || !envelope.intersects(this.getEnvelope(pathObject))) continue;
                    pathObjects.add(pathObject);
                }
            }
            if (pathObjects == null) {
                collection = Collections.emptySet();
                return collection;
            }
            collection = pathObjects;
            return collection;
        }
        finally {
            this.r.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasObjectsForRegion(Class<? extends PathObject> cls, ImageRegion region, boolean includeSubclasses) {
        this.ensureCacheConstructed();
        Envelope envelope = region == null ? MAX_ENVELOPE : this.getEnvelope(region);
        int z = region == null ? -1 : region.getZ();
        int t = region == null ? -1 : region.getT();
        this.r.lock();
        try {
            for (Map.Entry<Class<? extends PathObject>, SpatialIndex> entry : this.map.entrySet()) {
                if (cls != null && !Objects.equals(cls, entry.getKey()) && (!includeSubclasses || !cls.isAssignableFrom(entry.getKey())) || entry.getValue() == null) continue;
                List list = entry.getValue().query(envelope);
                for (PathObject pathObject : list) {
                    ROI roi = pathObject.getROI();
                    if (roi == null) continue;
                    if (region == null) {
                        boolean bl = true;
                        return bl;
                    }
                    if (roi.getZ() != z || roi.getT() != t) continue;
                    if (!region.intersects(roi.getBoundsX(), roi.getBoundsY(), roi.getBoundsWidth(), roi.getBoundsHeight())) continue;
                    boolean bl = true;
                    return bl;
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.r.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void hierarchyChanged(PathObjectHierarchyEvent event) {
        this.w.lock();
        try {
            PathObject singleObject;
            boolean singleChange = event.getChangedObjects().size() == 1;
            PathObject pathObject = singleObject = singleChange ? event.getChangedObjects().getFirst() : null;
            if (singleChange && event.getEventType() == PathObjectHierarchyEvent.HierarchyEventType.ADDED) {
                this.removeFromCache(singleObject, false);
                this.addToCache(singleObject, false, singleObject.getClass());
            } else if (singleChange && event.getEventType() == PathObjectHierarchyEvent.HierarchyEventType.REMOVED) {
                this.removeFromCache(singleObject, false);
            } else if (!(event.getEventType() != PathObjectHierarchyEvent.HierarchyEventType.OTHER_STRUCTURE_CHANGE && event.getEventType() != PathObjectHierarchyEvent.HierarchyEventType.CHANGE_OTHER || event.isChanging())) {
                this.resetCache();
            }
        }
        finally {
            this.w.unlock();
        }
    }
}

