/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.objects.classes;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.common.ColorTools;
import qupath.lib.objects.classes.PathClassTools;

public final class PathClass
implements Comparable<PathClass>,
Serializable {
    private static final Logger logger = LoggerFactory.getLogger(PathClass.class);
    private static final long serialVersionUID = 1L;
    private static boolean VALIDATION_STRICT = "true".equalsIgnoreCase(System.getProperty("pathClassString", "false").strip());
    public static final String NAME_POSITIVE = "Positive";
    public static final String NAME_NEGATIVE = "Negative";
    public static final String NAME_ONE_PLUS = "1+";
    public static final String NAME_TWO_PLUS = "2+";
    public static final String NAME_THREE_PLUS = "3+";
    private static final Integer COLOR_POSITIVE = ColorTools.packRGB(200, 50, 50);
    private static final Integer COLOR_NEGATIVE = ColorTools.packRGB(90, 90, 180);
    private static final Integer COLOR_ONE_PLUS = ColorTools.packRGB(255, 215, 0);
    private static final Integer COLOR_TWO_PLUS = ColorTools.packRGB(225, 150, 50);
    private static final Integer COLOR_THREE_PLUS = ColorTools.packRGB(200, 50, 50);
    private static final String DELIMITER_DEFAULT = ":";
    public static final String DELIMITER = PathClass.validDelimiterOrDefault(System.getProperty("pathClassDelimiter"));
    private static String defaultName = "Unclassified";
    private static Integer DEFAULT_COLOR = ColorTools.packRGB(64, 64, 64);
    private final PathClass parentClass;
    private final String name;
    private Integer colorRGB;
    private static final UUID secret = UUID.randomUUID();
    private transient String stringRep = null;
    public static final PathClass NULL_CLASS = new PathClass(secret);
    private static final List<String> illegalCharacters = Arrays.asList("\n", ":", "\r");
    private static final Map<String, PathClass> existingClasses = new ConcurrentHashMap<String, PathClass>();
    private volatile transient Set<String> set;
    private volatile transient List<String> list;
    private static final String CACHE_DELIMITER = "\n";
    private static final Pattern PATTERN_NAME = Pattern.compile("[\\w\\p{L}\\d\\p{Punct} ]+");

    private static String validDelimiterOrDefault(String delim) {
        if (delim == null || delim.isEmpty()) {
            return DELIMITER_DEFAULT;
        }
        return delim.contains(CACHE_DELIMITER) ? DELIMITER_DEFAULT : delim;
    }

    private static final UUID getSecret() {
        throw new UnsupportedOperationException("Don't ask me to share my secret!");
    }

    static synchronized void resetCaches() {
        logger.warn("Resetting PathClass caches");
        existingClasses.clear();
    }

    private PathClass(UUID mySecret) {
        if (!Objects.equals(secret, mySecret)) {
            throw new IllegalStateException("You should not access the PathClass constructor!");
        }
        if (NULL_CLASS != null) {
            throw new IllegalStateException("The NULL PathClass should not be created more than once!");
        }
        this.parentClass = null;
        this.name = null;
        this.colorRGB = null;
    }

    private PathClass(UUID mySecret, PathClass parent, String name, Integer colorRGB) {
        if (!Objects.equals(secret, mySecret)) {
            throw new IllegalStateException("You should not access the PathClass constructor! Use PathClass.getInstance() instead.");
        }
        name = PathClass.validateNameNotNull(name, true);
        if (parent == null) {
            logger.debug("Creating PathClass with name '{}'", (Object)name);
        } else {
            logger.debug("Deriving PathClass from {} with name '{}'", (Object)parent, (Object)name);
        }
        name = PathClass.validateNameStripped(name, VALIDATION_STRICT);
        name = PathClass.validateNameNotBlank(name, true);
        if (!PathClass.isValidName(name)) {
            throw new IllegalArgumentException(name + " is not a valid PathClass name!");
        }
        name = PathClass.validateNameCharacters(name, VALIDATION_STRICT);
        this.parentClass = parent;
        this.name = name;
        this.colorRGB = colorRGB == null ? DEFAULT_COLOR : colorRGB;
        if (existingClasses.containsKey(PathClass.createCacheString(this))) {
            throw new IllegalStateException("Cannot create the same PathClass more than once!");
        }
    }

    public PathClass getParentClass() {
        return this.parentClass;
    }

    public boolean isDerivedClass() {
        return this.parentClass != null;
    }

    public boolean isDerivedFrom(PathClass parentClass) {
        PathClass pathClass = this;
        while (pathClass != null) {
            if (pathClass.equals(parentClass)) {
                return true;
            }
            pathClass = pathClass.parentClass;
        }
        return false;
    }

    public boolean isAncestorOf(PathClass childClass) {
        PathClass pathClass = childClass;
        while (pathClass != null) {
            if (this.equals(pathClass)) {
                return true;
            }
            pathClass = pathClass.parentClass;
        }
        return false;
    }

    public PathClass getBaseClass() {
        PathClass temp = this;
        while (temp.getParentClass() != null) {
            temp = temp.getParentClass();
        }
        return temp;
    }

    public void setColor(Integer colorRGB) {
        if (colorRGB == null || !colorRGB.equals(this.colorRGB)) {
            this.colorRGB = colorRGB;
        }
    }

    public void setColor(int red, int green, int blue) {
        this.setColor(ColorTools.packRGB(red, green, blue));
    }

    public Integer getColor() {
        return this.colorRGB;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        if (this.stringRep == null) {
            this.stringRep = this.toString(DELIMITER + " ");
        }
        return this.stringRep;
    }

    public String toString(String delimiter) {
        if (this.name == null) {
            return defaultName;
        }
        if (this.isDerivedClass()) {
            return PathClass.createString(this.parentClass, this.name, delimiter);
        }
        return this.name;
    }

    public boolean isValid() {
        return this.name != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> toSet() {
        if (this.set == null) {
            PathClass pathClass = this;
            synchronized (pathClass) {
                if (this.set == null) {
                    this.set = this.createSet();
                }
            }
        }
        return this.set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<String> toList() {
        if (this.list == null) {
            PathClass pathClass = this;
            synchronized (pathClass) {
                if (this.list == null) {
                    this.list = this.createList();
                }
            }
        }
        return this.list;
    }

    private List<String> createList() {
        if (this == NULL_CLASS) {
            return Collections.emptyList();
        }
        if (!this.isDerivedClass()) {
            return Collections.singletonList(this.getName());
        }
        return PathClassTools.splitNames(this);
    }

    private Set<String> createSet() {
        if (this == NULL_CLASS) {
            return Collections.emptySet();
        }
        if (!this.isDerivedClass()) {
            return Collections.singleton(this.getName());
        }
        return Collections.unmodifiableSet(new LinkedHashSet<String>(PathClassTools.splitNames(this)));
    }

    @Override
    public int compareTo(PathClass o) {
        return this.toString().compareTo(o.toString());
    }

    private static boolean isValidName(String name) {
        if (name == null || name.isBlank()) {
            return false;
        }
        for (String illegal : illegalCharacters) {
            if (!name.contains(illegal)) continue;
            return false;
        }
        return true;
    }

    public static PathClass getNullClass() {
        return NULL_CLASS;
    }

    private static String createCacheStringForNameCollection(Collection<String> names) {
        return PathClass.createStringForNameCollection(names, CACHE_DELIMITER);
    }

    private static String createCacheString(PathClass parent) {
        return PathClass.createString(parent, null, CACHE_DELIMITER);
    }

    private static String createCacheString(PathClass parent, String name) {
        return PathClass.createString(parent, name, CACHE_DELIMITER);
    }

    private static String createString(PathClass parent, String name, String delimiter) {
        if (parent == null || parent == NULL_CLASS) {
            return PathClass.createStringForSingleName(name);
        }
        String start = !parent.isDerivedClass() ? PathClass.createStringForSingleName(parent.getName()) : PathClass.createStringForNameCollection(parent.toList(), delimiter);
        if (name == null) {
            return start;
        }
        return start + delimiter + PathClass.createStringForSingleName(name);
    }

    private static String createStringForNameCollection(Collection<String> names, String delimiter) {
        if (names.isEmpty()) {
            return "";
        }
        if (names.stream().anyMatch(p -> p == null)) {
            throw new IllegalArgumentException("PathClass cannot contain 'null' name: " + String.valueOf(names));
        }
        return names.stream().map(n -> PathClass.validateNameStripped(n, false)).collect(Collectors.joining(delimiter));
    }

    private static String createStringForSingleName(String name) {
        if (name == null) {
            return "";
        }
        return PathClass.validateNameStripped(name, false);
    }

    public static PathClass fromString(String string) {
        return PathClass.fromString(string, null);
    }

    public static PathClass fromString(String string, Integer color) {
        if (string == null) {
            return NULL_CLASS;
        }
        List<String> names = Arrays.stream(string.split(DELIMITER)).map(String::strip).toList();
        return PathClass.fromCollection(names, color);
    }

    public static PathClass fromCollection(Collection<String> names) {
        return PathClass.fromCollection(names, null);
    }

    public static PathClass fromCollection(Collection<String> names, Integer color) {
        if (names.isEmpty()) {
            return NULL_CLASS;
        }
        if (names.size() == 1) {
            return PathClass.getInstance(names.iterator().next(), color);
        }
        String string = PathClass.createCacheStringForNameCollection(names);
        PathClass pathClass = existingClasses.getOrDefault(string, null);
        if (pathClass != null) {
            return pathClass;
        }
        ArrayList<String> list = new ArrayList<String>(names);
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            pathClass = PathClass.getInstance(pathClass, list.get(i), i == n - 1 ? color : null);
        }
        return pathClass;
    }

    public static PathClass getInstance(String name) {
        return PathClass.getInstance(name, null);
    }

    public static PathClass getInstance(String name, Integer color) {
        return PathClass.getInstance(null, name, color);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PathClass getInstance(PathClass parent, String name, Integer color) {
        if (parent == NULL_CLASS) {
            parent = null;
        }
        if (name != null && name.contains(DELIMITER)) {
            throw new IllegalArgumentException(String.format("Name '%s' contains the delimiter '%s' - please use a valid name or getInstanceFromString()", name, DELIMITER));
        }
        if (parent == null) {
            if (name == null) {
                return NULL_CLASS;
            }
            String string = PathClass.createStringForSingleName(name);
            PathClass pathClass = existingClasses.getOrDefault(string, null);
            if (pathClass != null) {
                return pathClass;
            }
            Integer rgb = PathClass.getDefaultColor(null, name, color, string);
            Map<String, PathClass> map = existingClasses;
            synchronized (map) {
                return existingClasses.computeIfAbsent(string, s -> new PathClass(secret, null, name, rgb));
            }
        }
        if (name == null) {
            throw new IllegalArgumentException("Cannot derive a PathClass with a null name and non-null parent");
        }
        String string = PathClass.createCacheString(parent, name);
        PathClass pathClass = existingClasses.getOrDefault(string, null);
        if (pathClass != null) {
            return pathClass;
        }
        PathClass parent2 = parent;
        Integer rgb = PathClass.getDefaultColor(parent, name, color, string);
        Map<String, PathClass> map = existingClasses;
        synchronized (map) {
            return existingClasses.computeIfAbsent(string, s -> new PathClass(secret, parent2, name, rgb));
        }
    }

    public static PathClass getOnePlus(PathClass parentClass) {
        return PathClass.getInstance(parentClass, NAME_ONE_PLUS, null);
    }

    public static PathClass getTwoPlus(PathClass parentClass) {
        return PathClass.getInstance(parentClass, NAME_TWO_PLUS, null);
    }

    public static PathClass getThreePlus(PathClass parentClass) {
        return PathClass.getInstance(parentClass, NAME_THREE_PLUS, null);
    }

    public static PathClass getNegative(PathClass parentClass) {
        return PathClass.getInstance(parentClass, NAME_NEGATIVE, null);
    }

    public static PathClass getPositive(PathClass parentClass) {
        return PathClass.getInstance(parentClass, NAME_POSITIVE, null);
    }

    private static Integer getDefaultColor(PathClass parent, String name, Integer integer, String cacheName) {
        if (integer != null) {
            return integer;
        }
        if (parent == null) {
            if (name.equals(NAME_ONE_PLUS)) {
                return ColorTools.makeScaledRGB(COLOR_ONE_PLUS, 1.25);
            }
            if (name.equals(NAME_TWO_PLUS)) {
                return ColorTools.makeScaledRGB(COLOR_TWO_PLUS, 1.25);
            }
            if (name.equals(NAME_THREE_PLUS)) {
                return ColorTools.makeScaledRGB(COLOR_THREE_PLUS, 1.25);
            }
            if (name.equals(NAME_POSITIVE)) {
                return ColorTools.makeScaledRGB(COLOR_POSITIVE, 1.25);
            }
            if (name.equals(NAME_NEGATIVE)) {
                return ColorTools.makeScaledRGB(COLOR_NEGATIVE, 1.25);
            }
        } else {
            boolean isTumor = !parent.isDerivedClass() && "Tumor".equals(parent.getName());
            int parentRGB = parent.getColor();
            if (name.equals(NAME_ONE_PLUS)) {
                return isTumor ? COLOR_ONE_PLUS : ColorTools.makeScaledRGB(parentRGB, 0.9);
            }
            if (name.equals(NAME_TWO_PLUS)) {
                return isTumor ? COLOR_TWO_PLUS : ColorTools.makeScaledRGB(parentRGB, 0.6);
            }
            if (name.equals(NAME_THREE_PLUS)) {
                return isTumor ? COLOR_THREE_PLUS : ColorTools.makeScaledRGB(parentRGB, 0.4);
            }
            if (name.equals(NAME_POSITIVE)) {
                return isTumor ? COLOR_POSITIVE : ColorTools.makeScaledRGB(parentRGB, 0.75);
            }
            if (name.equals(NAME_NEGATIVE)) {
                return isTumor ? COLOR_NEGATIVE : ColorTools.makeScaledRGB(parentRGB, 1.25);
            }
        }
        Random random = new Random(cacheName.hashCode());
        int r = 0;
        int g = 0;
        int b = 0;
        while (r < 40 && g < 40 && b < 40) {
            r = random.nextInt(256);
            g = random.nextInt(256);
            b = random.nextInt(256);
        }
        return ColorTools.packRGB(r, g, b);
    }

    public static synchronized PathClass getSingleton(PathClass pathClass) {
        if (pathClass == null) {
            return null;
        }
        if (!pathClass.isDerivedClass() && pathClass.getName() == null) {
            return NULL_CLASS;
        }
        if (pathClass.isDerivedClass()) {
            PathClass parent = PathClass.getSingleton(pathClass.getParentClass());
            return PathClass.getInstance(parent, pathClass.getName(), pathClass.getColor());
        }
        PathClass previous = existingClasses.putIfAbsent(PathClass.createCacheString(pathClass), pathClass);
        return previous == null ? pathClass : previous;
    }

    public static PathClass fromArray(String ... names) {
        return PathClass.fromCollection(Arrays.asList(names));
    }

    private static String validateNameNotNull(String name, boolean exceptOnFail) {
        if (name == null && exceptOnFail) {
            throw new IllegalArgumentException("Requested PathClass name cannot be null!");
        }
        return name;
    }

    private static String validateNameNotBlank(String name, boolean exceptOnFail) {
        if (name.isBlank() && exceptOnFail) {
            throw new IllegalArgumentException("Requested PathClass name cannot be blank!");
        }
        return name;
    }

    private static String validateNameStripped(String name, boolean exceptOnFail) {
        String stripped = name.strip();
        if (name.length() != stripped.length()) {
            if (exceptOnFail) {
                throw new IllegalArgumentException("Unsupported classification name '" + name + "' - leading or training whitespace is not allowed");
            }
            logger.warn("PathClass names should not contain leading or trailing whitespace - '{}' will be stripped to become '{}'", (Object)name, (Object)stripped);
        }
        return stripped;
    }

    private static String validateNameCharacters(String name, boolean exceptOnFail) {
        if (name.contains(DELIMITER)) {
            throw new IllegalArgumentException("Invalid PathClass name - contains delimiter: " + name);
        }
        if (PATTERN_NAME.matcher(name).matches()) {
            return name;
        }
        if (exceptOnFail) {
            throw new IllegalArgumentException("Invalid PathClass name: " + name);
        }
        logger.warn("PathClass name '{}' contains invalid characters - this may fail on later QuPath versions", (Object)name);
        return name;
    }

    protected Object readResolve() throws ObjectStreamException {
        return PathClass.getSingleton(this);
    }

    public static class StandardPathClasses {
        public static final PathClass TUMOR = PathClass.getInstance("Tumor", ColorTools.packRGB(200, 0, 0));
        public static final PathClass STROMA = PathClass.getInstance("Stroma", ColorTools.packRGB(150, 200, 150));
        public static final PathClass IMMUNE_CELLS = PathClass.getInstance("Immune cells", ColorTools.packRGB(160, 90, 160));
        public static final PathClass IGNORE = PathClass.getInstance("Ignore*", ColorTools.packRGB(180, 180, 180));
        public static final PathClass IMAGE_ROOT = PathClass.getInstance("Image", ColorTools.packRGB(128, 128, 128));
        public static final PathClass NECROSIS = PathClass.getInstance("Necrosis", ColorTools.packRGB(50, 50, 50));
        public static final PathClass OTHER = PathClass.getInstance("Other", ColorTools.packRGB(255, 200, 0));
        public static final PathClass REGION = PathClass.getInstance("Region*", ColorTools.packRGB(0, 0, 180));
        public static final PathClass POSITIVE = PathClass.getPositive(null);
        public static final PathClass NEGATIVE = PathClass.getNegative(null);
    }
}

