/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.objects;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.common.LogTools;
import qupath.lib.objects.MetadataStore;
import qupath.lib.objects.PathROIObject;
import qupath.lib.roi.interfaces.ROI;

public class TMACoreObject
extends PathROIObject
implements MetadataStore {
    private static final Logger logger = LoggerFactory.getLogger(TMACoreObject.class);
    private static final long serialVersionUID = 1L;
    @Deprecated
    public static final String LEGACY_KEY_UNIQUE_ID = "Unique ID";
    public static final String KEY_CASE_ID = "Case ID";
    public static final String KEY_OVERALL_SURVIVAL = "Overall survival";
    public static final String KEY_RECURRENCE_FREE_SURVIVAL = "Recurrence-free survival";
    public static final String KEY_OS_CENSORED = "OS censored";
    public static final String KEY_RFS_CENSORED = "RFS censored";
    private boolean isMissing = false;

    public TMACoreObject() {
    }

    TMACoreObject(ROI roi, boolean isMissing) {
        super(roi, null);
        this.isMissing = isMissing;
    }

    public boolean isMissing() {
        return this.isMissing;
    }

    public void setMissing(boolean missing) {
        this.isMissing = missing;
    }

    public String getCaseID() {
        return this.getMetadataString(KEY_CASE_ID);
    }

    public void setCaseID(String caseID) {
        this.putMetadataValue(KEY_CASE_ID, caseID);
    }

    @Override
    @Deprecated
    public Object putMetadataValue(String key, String value) {
        return this.storeMetadataValue(key, value);
    }

    @Override
    @Deprecated
    public String getMetadataString(String key) {
        Object value = this.getMetadataValue(key);
        if (value instanceof String) {
            return (String)value;
        }
        return null;
    }

    @Override
    @Deprecated
    public Object getMetadataValue(String key) {
        return super.retrieveMetadataValue(key);
    }

    @Override
    @Deprecated
    public Set<String> getMetadataKeys() {
        return super.retrieveMetadataKeys();
    }

    @Deprecated
    public void clearMetadata() {
        super.clearMetadataMap();
    }

    @Override
    public String toString() {
        return this.getDisplayedName() + this.objectCountPostfix();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeBoolean(this.isMissing);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.isMissing = in.readBoolean();
        String legacyCaseID = this.getMetadataString(LEGACY_KEY_UNIQUE_ID);
        if (this.getCaseID() == null && legacyCaseID != null) {
            LogTools.warnOnce(logger, "Updating legacy 'Unique ID' to 'Case ID' (introduced in v0.4.0)");
            this.setCaseID(legacyCaseID);
        }
    }
}

