/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.objects;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.measurements.MeasurementList;
import qupath.lib.objects.PathObject;
import qupath.lib.objects.classes.PathClass;
import qupath.lib.roi.interfaces.ROI;

public abstract class PathROIObject
extends PathObject {
    private static Logger logger = LoggerFactory.getLogger(PathROIObject.class);
    private static final long serialVersionUID = 1L;
    private PathClass pathClass = null;
    private ROI pathROI = null;
    private double classProbability = Double.NaN;
    private boolean lockedROI = false;

    PathROIObject() {
    }

    PathROIObject(ROI pathROI, PathClass pc) {
        this.pathROI = pathROI;
        this.setPathClass(pc);
    }

    PathROIObject(MeasurementList measurements) {
        super(measurements);
    }

    PathROIObject(ROI pathROI, PathClass pc, MeasurementList measurements) {
        super(measurements);
        this.pathROI = pathROI;
        this.setPathClass(pc);
    }

    public void setROI(ROI roi) {
        if (roi == null) {
            throw new IllegalArgumentException("PathROIObject.setROI cannot be called with null!");
        }
        if (this.pathROI != roi) {
            this.pathROI = roi;
            if (this.hasMeasurements()) {
                this.getMeasurementList().clear();
            }
        }
    }

    @Override
    public void setLocked(boolean locked) {
        this.lockedROI = locked;
    }

    @Override
    public boolean isLocked() {
        return this.lockedROI;
    }

    @Override
    @Deprecated
    public boolean isEditable() {
        return !this.isLocked();
    }

    @Override
    public void setPathClass(PathClass pathClass, double classProbability) {
        if (pathClass == null) {
            this.pathClass = pathClass;
            this.classProbability = classProbability;
            return;
        }
        if (pathClass == PathClass.NULL_CLASS) {
            logger.warn("Please use PathObject.resetPathClass() instead of setting to PathClassFactory.NULL_CLASS");
            pathClass = null;
        } else if (!pathClass.isValid()) {
            logger.warn("Classification {} is invalid! Will be set to null instead", (Object)pathClass);
            pathClass = null;
        }
        this.pathClass = pathClass;
        this.classProbability = classProbability;
        if (this.pathClass != null && this.getColor() != null) {
            logger.debug("Resetting PathObject color to use the color of the PathClass instead");
            this.setColor(null);
        }
    }

    @Override
    public double getClassProbability() {
        return this.classProbability;
    }

    @Override
    public PathClass getPathClass() {
        return this.pathClass;
    }

    @Override
    public ROI getROI() {
        return this.pathROI;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.lockedROI);
        out.writeObject(this.pathClass);
        out.writeObject(this.pathROI);
        out.writeDouble(this.classProbability);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        Object firstObject = in.readObject();
        if (firstObject instanceof Boolean) {
            this.lockedROI = (Boolean)firstObject;
            firstObject = in.readObject();
        }
        if (firstObject instanceof PathClass) {
            this.pathClass = (PathClass)firstObject;
        }
        if (this.pathClass != null) {
            this.pathClass = PathClass.getSingleton(this.pathClass);
        }
        this.pathROI = (ROI)in.readObject();
        this.classProbability = in.readDouble();
    }
}

