/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.objects;

import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Predicate;
import qupath.lib.io.GsonTools;
import qupath.lib.objects.PathObject;
import qupath.lib.objects.PathObjectFilter;
import qupath.lib.objects.classes.PathClass;
import qupath.lib.objects.classes.PathClassTools;

public class PathObjectPredicates {
    private static final GsonTools.SubTypeAdapterFactory<PathObjectPredicate> typeAdapterFactory = GsonTools.createSubTypeAdapterFactory(PathObjectPredicate.class, "predicate_type").registerSubtype(PathObjectClassPredicate.class, "classified").registerSubtype(PathObjectClassNamePredicate.class, "classified-name").registerSubtype(PathObjectClassPositivePredicate.class, "classified-positive").registerSubtype(PathObjectAndPredicate.class, "and").registerSubtype(PathObjectOrPredicate.class, "or").registerSubtype(PathObjectNegatePredicate.class, "negate").registerSubtype(PathObjectFilterPredicate.class, "filter");

    public static PathObjectPredicate positiveClassification(boolean allowGradedIntensity) {
        return new PathObjectClassPositivePredicate(allowGradedIntensity);
    }

    public static PathObjectPredicate filter(PathObjectFilter filter) {
        return new PathObjectFilterPredicate(filter);
    }

    public static PathObjectPredicate exactClassification(PathClass ... pathClasses) {
        if (pathClasses.length == 0) {
            throw new IllegalArgumentException("No PathClasses specified!");
        }
        return new PathObjectClassPredicate(false, pathClasses);
    }

    public static PathObjectPredicate containsClassification(String ... names) {
        if (names.length == 0) {
            throw new IllegalArgumentException("No PathClasses specified!");
        }
        return new PathObjectClassNamePredicate(names);
    }

    public static PathObjectPredicate baseClassification(PathClass ... pathClasses) {
        if (pathClasses.length == 0) {
            throw new IllegalArgumentException("No PathClasses specified!");
        }
        return new PathObjectClassPredicate(true, pathClasses);
    }

    static {
        GsonTools.getDefaultBuilder().registerTypeAdapterFactory(typeAdapterFactory);
    }

    static class PathObjectClassPositivePredicate
    extends AbstractPathObjectPredicate {
        private boolean allowGradedIntensity;

        PathObjectClassPositivePredicate(boolean allowGradedIntensity) {
            this.allowGradedIntensity = allowGradedIntensity;
        }

        @Override
        public boolean test(PathObject t) {
            PathClass pathClass = t.getPathClass();
            if (this.allowGradedIntensity) {
                return PathClassTools.isPositiveOrGradedIntensityClass(pathClass);
            }
            return PathClassTools.isPositiveClass(pathClass);
        }
    }

    static class PathObjectFilterPredicate
    extends AbstractPathObjectPredicate {
        private PathObjectFilter filter;

        private PathObjectFilterPredicate(PathObjectFilter filter) {
            this.filter = filter;
        }

        @Override
        public boolean test(PathObject t) {
            return this.filter.test(t);
        }
    }

    static class PathObjectClassPredicate
    extends AbstractPathObjectPredicate {
        private Set<String> pathClasses;
        private boolean baseClass = false;

        private PathObjectClassPredicate(boolean baseClass, PathClass ... pathClasses) {
            this.baseClass = baseClass;
            this.pathClasses = new LinkedHashSet<String>();
            for (PathClass pc : pathClasses) {
                if (pc == null) {
                    this.pathClasses.add(null);
                    continue;
                }
                this.pathClasses.add(pc.toString());
            }
        }

        @Override
        public boolean test(PathObject t) {
            PathClass pathClass = t.getPathClass();
            if (this.baseClass) {
                PathClass pathClass2 = pathClass = pathClass == null ? null : pathClass.getBaseClass();
            }
            if (pathClass == null) {
                return this.pathClasses.contains(null);
            }
            return this.pathClasses.contains(pathClass.toString());
        }
    }

    static class PathObjectClassNamePredicate
    extends AbstractPathObjectPredicate {
        private Set<String> pathClassNames = new LinkedHashSet<String>();

        private PathObjectClassNamePredicate(String ... pathClassNames) {
            for (String name : pathClassNames) {
                if (name == null) {
                    throw new IllegalArgumentException("Class name cannot be null!");
                }
                this.pathClassNames.add(name);
            }
        }

        @Override
        public boolean test(PathObject t) {
            PathClass pathClass = t.getPathClass();
            for (String name : this.pathClassNames) {
                if (!PathClassTools.containsName(pathClass, name)) continue;
                return true;
            }
            return false;
        }
    }

    public static interface PathObjectPredicate
    extends Predicate<PathObject> {
        public PathObjectPredicate and(PathObjectPredicate var1);

        public PathObjectPredicate or(PathObjectPredicate var1);

        default public PathObjectPredicate negate() {
            return new PathObjectNegatePredicate(this);
        }
    }

    static class PathObjectAndPredicate
    extends AbstractPathObjectPredicate {
        private PathObjectPredicate predicate1;
        private PathObjectPredicate predicate2;

        private PathObjectAndPredicate(PathObjectPredicate p1, PathObjectPredicate p2) {
            this.predicate1 = p1;
            this.predicate2 = p2;
        }

        @Override
        public boolean test(PathObject t) {
            return this.predicate1.test(t) && this.predicate2.test(t);
        }
    }

    static class PathObjectOrPredicate
    extends AbstractPathObjectPredicate {
        private PathObjectPredicate predicate1;
        private PathObjectPredicate predicate2;

        private PathObjectOrPredicate(PathObjectPredicate p1, PathObjectPredicate p2) {
            this.predicate1 = p1;
            this.predicate2 = p2;
        }

        @Override
        public boolean test(PathObject t) {
            return this.predicate1.test(t) || this.predicate2.test(t);
        }
    }

    static class PathObjectNegatePredicate
    extends AbstractPathObjectPredicate {
        private PathObjectPredicate predicate;

        private PathObjectNegatePredicate(PathObjectPredicate p) {
            this.predicate = p;
        }

        @Override
        public boolean test(PathObject t) {
            return !this.predicate.test(t);
        }
    }

    static abstract class AbstractPathObjectPredicate
    implements PathObjectPredicate {
        AbstractPathObjectPredicate() {
        }

        @Override
        public PathObjectPredicate and(PathObjectPredicate p) {
            return new PathObjectAndPredicate(this, p);
        }

        @Override
        public PathObjectPredicate or(PathObjectPredicate p) {
            return new PathObjectOrPredicate(this, p);
        }
    }
}

