/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.objects;

import java.util.function.Predicate;
import qupath.lib.objects.PathDetectionObject;
import qupath.lib.objects.PathObject;
import qupath.lib.objects.classes.PathClassTools;

public enum PathObjectFilter implements Predicate<PathObject>
{
    ANNOTATIONS,
    DETECTIONS,
    DETECTIONS_ALL,
    CELLS,
    TILES,
    TMA_CORES,
    UNLOCKED,
    ROI,
    ROI_LINE,
    ROI_AREA,
    ROI_POINT,
    UNCLASSIFIED,
    CLASSIFIED;


    public String toString() {
        return switch (this.ordinal()) {
            case 0 -> "Annotations";
            case 3 -> "Cells";
            case 1 -> "Detections (no subtypes)";
            case 2 -> "Detections (all)";
            case 4 -> "Tiles";
            case 5 -> "TMA cores";
            case 6 -> "Unlocked";
            case 7 -> "Has ROI";
            case 8 -> "Has line ROI";
            case 9 -> "Has area ROI";
            case 10 -> "Has point ROI";
            case 12 -> "Has classification";
            case 11 -> "Has no classification";
            default -> throw new IllegalArgumentException();
        };
    }

    @Override
    public boolean test(PathObject p) {
        return switch (this.ordinal()) {
            case 0 -> p.isAnnotation();
            case 3 -> p.isCell();
            case 2 -> p.isDetection();
            case 1 -> {
                if (p.isDetection() && PathDetectionObject.class.equals(p.getClass())) {
                    yield true;
                }
                yield false;
            }
            case 4 -> p.isTile();
            case 5 -> p.isTMACore();
            case 6 -> {
                if (!p.isLocked()) {
                    yield true;
                }
                yield false;
            }
            case 7 -> p.hasROI();
            case 8 -> {
                if (p.hasROI() && p.getROI().isLine()) {
                    yield true;
                }
                yield false;
            }
            case 9 -> {
                if (p.hasROI() && p.getROI().isArea()) {
                    yield true;
                }
                yield false;
            }
            case 10 -> {
                if (p.hasROI() && p.getROI().isPoint()) {
                    yield true;
                }
                yield false;
            }
            case 12 -> {
                if (p.getPathClass() != null && !PathClassTools.isNullClass(p.getPathClass())) {
                    yield true;
                }
                yield false;
            }
            case 11 -> {
                if (p.getPathClass() == null || PathClassTools.isNullClass(p.getPathClass())) {
                    yield true;
                }
                yield false;
            }
            default -> throw new IllegalArgumentException();
        };
    }
}

