/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.objects;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.common.ColorTools;
import qupath.lib.interfaces.MinimalMetadataStore;
import qupath.lib.io.PathIO;
import qupath.lib.measurements.MeasurementList;
import qupath.lib.measurements.MeasurementListFactory;
import qupath.lib.objects.MetadataMap;
import qupath.lib.objects.PathAnnotationObject;
import qupath.lib.objects.PathCellObject;
import qupath.lib.objects.PathDetectionObject;
import qupath.lib.objects.PathObjectTools;
import qupath.lib.objects.PathRootObject;
import qupath.lib.objects.PathTileObject;
import qupath.lib.objects.TMACoreObject;
import qupath.lib.objects.classes.PathClass;
import qupath.lib.roi.interfaces.ROI;

public abstract class PathObject
implements Externalizable,
MinimalMetadataStore {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(PathObject.class);
    private static final String METADATA_KEY_ID = "Object ID";
    private UUID id = UUID.randomUUID();
    private PathObject parent = null;
    private Collection<PathObject> childList = null;
    private MeasurementList measurements = null;
    private volatile MetadataMap metadata = null;
    private String name = null;
    private Integer color;
    private transient Collection<PathObject> cachedUnmodifiableChildren = null;
    private transient Map<String, Number> measurementsMap;

    public PathObject(MeasurementList measurements) {
        this();
        this.measurements = measurements;
    }

    public PathObject() {
    }

    public PathObject getParent() {
        return this.parent;
    }

    public void setLocked(boolean locked) {
        if (!locked) {
            throw new UnsupportedOperationException("Locked status cannot be unset!");
        }
    }

    public boolean isLocked() {
        return true;
    }

    public int getLevel() {
        if (this.parent == null) {
            return 0;
        }
        return this.parent.getLevel() + 1;
    }

    public boolean isRootObject() {
        return this instanceof PathRootObject;
    }

    public synchronized MeasurementList getMeasurementList() {
        if (this.measurements == null) {
            this.measurements = this.createEmptyMeasurementList();
        }
        return this.measurements;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Number> getMeasurements() {
        if (this.measurementsMap == null) {
            PathObject pathObject = this;
            synchronized (pathObject) {
                if (this.measurementsMap == null) {
                    this.measurementsMap = this.getMeasurementList().asMap();
                }
            }
        }
        return this.measurementsMap;
    }

    protected MeasurementList createEmptyMeasurementList() {
        MeasurementList list = MeasurementListFactory.createMeasurementList(16, MeasurementList.MeasurementListType.GENERAL);
        return list;
    }

    protected synchronized String objectCountPostfix() {
        String objString;
        ROI pathROI = this.getROI();
        if (pathROI != null && pathROI.isPoint()) {
            int nPoints = pathROI.getNumPoints();
            if (nPoints == 1) {
                return " (1 point)";
            }
            return String.format(" (%d points)", nPoints);
        }
        if (!this.hasChildObjects()) {
            return "";
        }
        int nChildren = this.nChildObjects();
        int nDescendants = PathObjectTools.countDescendants(this);
        String string = objString = nDescendants == 1 ? " object)" : " objects)";
        if (nChildren == nDescendants) {
            return " (" + nChildren + objString;
        }
        return " (" + nChildren + "/" + nDescendants + objString;
    }

    public String toString() {
        ROI roi;
        StringBuilder sb = new StringBuilder();
        if (this.getName() != null) {
            sb.append(this.getName());
        } else {
            sb.append(PathObjectTools.getSuitableName(this.getClass(), false));
        }
        if (this.getPathClass() != null) {
            sb.append(" (").append(this.getPathClass().toString()).append(")");
        }
        if (this.hasROI() && ((roi = this.getROI()).getZ() > 0 || roi.getT() > 0)) {
            if (roi.getZ() > 0) {
                sb.append(" (z=").append(roi.getZ());
                if (roi.getT() > 0) {
                    sb.append(", t=").append(roi.getT());
                }
                sb.append(")");
            } else {
                sb.append("(t=").append(roi.getT()).append(")");
            }
        }
        sb.append(this.objectCountPostfix());
        return sb.toString();
    }

    public synchronized void addChildObject(PathObject pathObject) {
        if (pathObject instanceof PathRootObject) {
            throw new IllegalArgumentException("PathRootObject cannot be added as child to another PathObject");
        }
        this.addChildObjectImpl(pathObject);
    }

    private synchronized void addChildObjectImpl(PathObject pathObject) {
        this.ensureChildList(this.nChildObjects() + 1);
        if (pathObject.parent != this) {
            if (pathObject.parent != null && pathObject.parent.childList != null) {
                pathObject.parent.childList.remove(pathObject);
            }
            pathObject.parent = this;
        }
        this.childList.add(pathObject);
    }

    private synchronized void addChildObjectsImpl(Collection<? extends PathObject> pathObjects) {
        if (pathObjects == null || pathObjects.isEmpty()) {
            return;
        }
        this.ensureChildList(this.nChildObjects() + pathObjects.size());
        Iterator<? extends PathObject> iter = pathObjects.iterator();
        PathObject lastBatchRemoveParent = null;
        ArrayList<PathObject> batchRemove = new ArrayList<PathObject>(pathObjects.size());
        boolean isChildList = false;
        while (iter.hasNext()) {
            PathObject pathObject = iter.next();
            PathObject pathObject2 = pathObject.parent;
            if (pathObject2 == this) continue;
            if (pathObject2 != null && pathObject2.childList != null) {
                if (pathObject2.getChildObjects().equals(pathObjects) || pathObject2.childList.equals(pathObjects)) {
                    isChildList = true;
                    lastBatchRemoveParent = pathObject2;
                    break;
                }
                if (lastBatchRemoveParent != pathObject2 && lastBatchRemoveParent != null && !batchRemove.isEmpty()) {
                    PathObject.removeAllQuickly(lastBatchRemoveParent.childList, batchRemove);
                    batchRemove.clear();
                }
                lastBatchRemoveParent = pathObject2;
                batchRemove.add(pathObject);
            }
            pathObject.parent = this;
        }
        if (isChildList) {
            for (PathObject pathObject : pathObjects) {
                pathObject.parent = this;
            }
        } else if (lastBatchRemoveParent != null && !batchRemove.isEmpty()) {
            PathObject.removeAllQuickly(lastBatchRemoveParent.childList, batchRemove);
        }
        this.childList.addAll(pathObjects);
        if (isChildList) {
            lastBatchRemoveParent.childList.clear();
        }
    }

    private static <T> void removeAllQuickly(Collection<T> list, Collection<T> toRemove) {
        int size = 10;
        if (!(toRemove instanceof Set) && toRemove.size() > size) {
            toRemove = new HashSet<T>(toRemove);
        }
        list.removeAll(toRemove);
    }

    public synchronized void addChildObjects(Collection<? extends PathObject> pathObjects) {
        this.addChildObjectsImpl(pathObjects);
    }

    public void removeChildObject(PathObject pathObject) {
        if (!this.hasChildObjects()) {
            return;
        }
        if (pathObject.parent == this) {
            pathObject.parent = null;
        }
        this.childList.remove(pathObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removeChildObjects(Collection<PathObject> pathObjects) {
        if (!this.hasChildObjects()) {
            return;
        }
        for (PathObject pathObject : pathObjects) {
            if (pathObject.parent != this) continue;
            pathObject.parent = null;
        }
        Collection<PathObject> collection = this.childList;
        synchronized (collection) {
            PathObject.removeAllQuickly(this.childList, pathObjects);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearChildObjects() {
        if (!this.hasChildObjects()) {
            return;
        }
        Collection<PathObject> collection = this.childList;
        synchronized (collection) {
            for (PathObject pathObject : this.childList) {
                if (pathObject.parent != this) continue;
                pathObject.parent = null;
            }
            this.childList.clear();
        }
    }

    public int nChildObjects() {
        return this.childList == null ? 0 : this.childList.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int nDescendants() {
        if (!this.hasChildObjects()) {
            return 0;
        }
        int total = 0;
        Collection<PathObject> collection = this.childList;
        synchronized (collection) {
            for (PathObject child : this.childList) {
                total += 1 + child.nDescendants();
            }
        }
        return total;
    }

    public boolean hasChildObjects() {
        return this.childList != null && !this.childList.isEmpty();
    }

    public boolean hasROI() {
        return this.getROI() != null;
    }

    public boolean isAnnotation() {
        return this instanceof PathAnnotationObject;
    }

    public boolean isDetection() {
        return this instanceof PathDetectionObject;
    }

    public boolean isCell() {
        return this instanceof PathCellObject;
    }

    public boolean hasMeasurements() {
        return this.measurements != null && !this.measurements.isEmpty();
    }

    public boolean isTMACore() {
        return this instanceof TMACoreObject;
    }

    public boolean isTile() {
        return this instanceof PathTileObject;
    }

    public abstract boolean isEditable();

    public Collection<PathObject> getChildObjects() {
        if (!this.hasChildObjects()) {
            return Collections.emptyList();
        }
        return this.cachedUnmodifiableChildren;
    }

    public Collection<PathObject> getChildObjects(Collection<PathObject> children) {
        if (children == null) {
            return this.getChildObjects();
        }
        if (!this.hasChildObjects()) {
            return children;
        }
        children.addAll(this.childList);
        return children;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<PathObject> getDescendantObjects(Collection<PathObject> descendants) {
        if (!this.hasChildObjects()) {
            return Collections.emptyList();
        }
        if (descendants == null) {
            descendants = new ArrayList<PathObject>();
        }
        Collection<PathObject> collection = this.childList;
        synchronized (collection) {
            for (PathObject child : this.childList) {
                descendants.add(child);
                if (!child.hasChildObjects()) continue;
                child.getDescendantObjects(descendants);
            }
        }
        return descendants;
    }

    public PathObject[] getChildObjectsAsArray() {
        return this.childList == null ? new PathObject[]{} : (PathObject[])this.childList.toArray(PathObject[]::new);
    }

    public abstract PathClass getPathClass();

    public void setPathClass(PathClass pathClass) {
        this.setPathClass(pathClass, Double.NaN);
    }

    public boolean resetPathClass() {
        PathClass previous = this.getPathClass();
        if (previous == null) {
            return false;
        }
        this.setPathClass(null);
        return true;
    }

    public void setClassifications(Collection<String> classifications) {
        if (classifications.isEmpty()) {
            this.resetPathClass();
        } else if (classifications instanceof Set) {
            this.setPathClass(PathClass.fromCollection(classifications));
        } else {
            LinkedHashSet<String> set = new LinkedHashSet<String>(classifications);
            if (set.size() < classifications.size()) {
                logger.warn("Input to setClassifications() contains duplicate elements - {} will be replaced by {}", classifications, set);
            }
            this.setPathClass(PathClass.fromCollection(set));
        }
    }

    public Set<String> getClassifications() {
        PathClass pc = this.getPathClass();
        if (pc == null) {
            return Collections.emptySet();
        }
        return pc.toSet();
    }

    public String getClassification() {
        PathClass pc = this.getPathClass();
        return pc == null || pc == PathClass.NULL_CLASS ? null : pc.toString();
    }

    public void setClassification(String classification) {
        if (classification == null || classification.isEmpty()) {
            this.resetPathClass();
        } else {
            this.setPathClass(PathClass.fromString(classification));
        }
    }

    public void setClassification(Object obj) {
        Object object = obj;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{String.class, Collection.class}, (Object)object, n)) {
            case -1: {
                this.resetPathClass();
                break;
            }
            case 0: {
                String s = (String)object;
                this.setClassification(s);
                break;
            }
            case 1: {
                Collection collection = (Collection)object;
                throw new IllegalArgumentException("setClassification(String) requires a string - did you mean to call setClassifications(Collection)?");
            }
            default: {
                throw new IllegalArgumentException("setClassification(String) requires a string input - cannot parse " + String.valueOf(obj));
            }
        }
    }

    public abstract void setPathClass(PathClass var1, double var2);

    public abstract double getClassProbability();

    public String getDisplayedName() {
        Object nameDisplayed = this.name;
        if (nameDisplayed == null) {
            PathClass pathClass = this.getPathClass();
            nameDisplayed = PathObjectTools.getSuitableName(this.getClass(), false);
            if (pathClass != null) {
                nameDisplayed = (String)nameDisplayed + " (" + pathClass.toString() + ")";
            }
        }
        if (this.getParent() != null && this.getParent().isTMACore()) {
            nameDisplayed = this.getParent().getDisplayedName() + " - " + (String)nameDisplayed;
        }
        return nameDisplayed;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public abstract ROI getROI();

    public Integer getColor() {
        return this.color;
    }

    public void setColor(Integer color) {
        this.color = color;
    }

    public void setColor(int red, int green, int blue) {
        this.setColor(ColorTools.packRGB(red, green, blue));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UUID getID() {
        if (this.id == null) {
            PathObject pathObject = this;
            synchronized (pathObject) {
                if (this.id == null) {
                    logger.debug("Generating a new UUID on request");
                    this.id = UUID.randomUUID();
                }
            }
        }
        return this.id;
    }

    public void setID(UUID id) throws IllegalArgumentException {
        if (id == null) {
            throw new IllegalArgumentException("ID of an object cannot be null!");
        }
        this.id = id;
    }

    public void refreshID() {
        this.setID(UUID.randomUUID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void ensureChildList(int capacity) {
        if (this.childList == null) {
            PathObject pathObject = this;
            synchronized (pathObject) {
                if (this.childList != null) {
                    return;
                }
                int n = 8;
                float loadFactor = 0.75f;
                if (capacity > 0) {
                    n = (int)Math.max((double)n, Math.ceil((float)capacity / loadFactor));
                }
                this.childList = Collections.synchronizedSet(new LinkedHashSet(n, loadFactor));
                this.cachedUnmodifiableChildren = Collections.unmodifiableCollection(this.childList);
            }
        }
    }

    @Deprecated
    protected Object storeMetadataValue(String key, String value) {
        if (this.metadata == null) {
            this.metadata = new MetadataMap();
        }
        return this.metadata.put(key, value);
    }

    @Deprecated
    protected Object retrieveMetadataValue(String key) {
        return this.metadata == null ? null : this.metadata.get(key);
    }

    @Deprecated
    protected Set<String> retrieveMetadataKeys() {
        return this.metadata == null ? Collections.emptySet() : this.metadata.keySet();
    }

    @Deprecated
    protected Map<String, String> getUnmodifiableMetadataMap() {
        return this.metadata == null ? Collections.emptyMap() : Collections.unmodifiableMap(this.metadata);
    }

    @Deprecated
    protected void clearMetadataMap() {
        if (this.metadata != null) {
            this.metadata.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> getMetadata() {
        if (this.metadata == null) {
            PathObject pathObject = this;
            synchronized (pathObject) {
                if (this.metadata == null) {
                    this.metadata = new MetadataMap();
                }
            }
        }
        return this.metadata;
    }

    public boolean hasMetadata() {
        return this.metadata != null && !this.metadata.isEmpty();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.name);
        out.writeObject(this.color);
        if (PathIO.getRequestedDataFileVersion() >= 4) {
            out.writeObject(this.id);
            int nFields = 1;
            if (this.metadata != null) {
                ++nFields;
            }
            out.writeInt(nFields);
            if (this.metadata != null && !this.metadata.isEmpty()) {
                out.writeObject(this.metadata);
            }
            out.writeObject(this.measurements);
        } else {
            MetadataMap tempMetadata = new MetadataMap();
            if (this.metadata != null) {
                tempMetadata.putAll(this.metadata);
            }
            if (this.id != null && !tempMetadata.containsKey(METADATA_KEY_ID)) {
                tempMetadata.put(METADATA_KEY_ID, this.id.toString());
            }
            out.writeObject(tempMetadata);
            out.writeObject(this.measurements);
        }
        int n = this.nChildObjects();
        out.writeInt(n);
        if (n > 0) {
            for (PathObject pathObject : this.childList) {
                out.writeObject(pathObject);
            }
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int nChildObjects;
        int i;
        Object nextObject;
        this.name = (String)in.readObject();
        Object colorObject = in.readObject();
        if (colorObject instanceof Integer) {
            this.color = (Integer)colorObject;
        }
        if ((nextObject = in.readObject()) instanceof UUID) {
            this.id = (UUID)nextObject;
            int nFields = in.readInt();
            for (i = 0; i < nFields; ++i) {
                nextObject = in.readObject();
                if (nextObject instanceof MetadataMap) {
                    MetadataMap mm = (MetadataMap)nextObject;
                    if (mm.isEmpty()) continue;
                    this.metadata = mm;
                    continue;
                }
                if (nextObject instanceof MeasurementList) {
                    MeasurementList ml;
                    this.measurements = ml = (MeasurementList)nextObject;
                    this.measurements.close();
                    continue;
                }
                if (nextObject != null) {
                    logger.debug("Unsupported field during deserialization {}", nextObject);
                    continue;
                }
                logger.debug("Null field during deserialization");
            }
        } else {
            if (nextObject instanceof MetadataMap) {
                this.metadata = (MetadataMap)nextObject;
                String idString = this.metadata.getOrDefault(METADATA_KEY_ID, null);
                if (idString != null && idString.length() <= 36 && idString.contains("-")) {
                    try {
                        this.id = UUID.fromString(idString);
                        if (this.metadata.size() == 1) {
                            this.metadata = null;
                        } else {
                            this.metadata.remove(METADATA_KEY_ID);
                        }
                    }
                    catch (Exception e) {
                        logger.debug("Unable to parse UUID from metadata ID");
                    }
                }
                nextObject = in.readObject();
            }
            if (nextObject instanceof MeasurementList) {
                this.measurements = (MeasurementList)nextObject;
                this.measurements.close();
            }
        }
        if (this.id == null) {
            this.id = UUID.randomUUID();
        }
        if ((nChildObjects = in.readInt()) > 0) {
            this.ensureChildList(nChildObjects);
            for (i = 0; i < nChildObjects; ++i) {
                PathObject child = (PathObject)in.readObject();
                child.parent = this;
                this.childList.add(child);
            }
        }
    }
}

