/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.objects;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MetadataMap
implements Map<String, String>,
Externalizable {
    private static final Logger logger = LoggerFactory.getLogger(MetadataMap.class);
    private static final long serialVersionUID = 1L;
    private Map<String, String> map;

    @Override
    public int size() {
        return this.map == null ? 0 : this.getMapInternal().size();
    }

    @Override
    public boolean isEmpty() {
        return this.map == null || this.getMapInternal().isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.getMapInternal().containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.getMapInternal().containsValue(value);
    }

    @Override
    public String get(Object key) {
        return this.getMapInternal().get(key);
    }

    @Override
    public String put(String key, String value) {
        return this.getMapInternalOrCreate().put(key, value);
    }

    @Override
    public String remove(Object key) {
        if (this.map == null) {
            return null;
        }
        return this.map.remove(key);
    }

    @Override
    public void putAll(Map<? extends String, ? extends String> m) {
        if (m.isEmpty()) {
            return;
        }
        this.getMapInternalOrCreate().putAll(m);
    }

    @Override
    public void clear() {
        if (this.map == null) {
            return;
        }
        this.map.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.getMapInternal().keySet();
    }

    @Override
    public Collection<String> values() {
        return this.getMapInternal().values();
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        return this.getMapInternal().entrySet();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(1);
        Map<String, String> map = this.getMapInternal();
        out.writeObject(map.keySet().toArray());
        out.writeObject(map.values().toArray());
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        in.readObject();
        Object[] keys = (Object[])in.readObject();
        Object[] values = (Object[])in.readObject();
        if (keys.length > 0) {
            Map<String, String> mapInternal = this.getMapInternalOrCreate();
            for (int i = 0; i < keys.length; ++i) {
                mapInternal.put((String)keys[i], (String)values[i]);
            }
        }
    }

    private Map<String, String> getMapInternal() {
        if (this.map == null) {
            return Collections.emptyMap();
        }
        return this.map;
    }

    private Map<String, String> getMapInternalOrCreate() {
        if (this.map == null) {
            logger.trace("Creating MetadataMap");
            this.map = new LinkedHashMap<String, String>();
        }
        return this.map;
    }

    public String toString() {
        return this.getMapInternal().toString();
    }
}

