/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.measurements;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.LoggerFactory;
import qupath.lib.measurements.Measurement;

public interface MeasurementList
extends Serializable,
AutoCloseable {
    public void put(String var1, double var2);

    public List<Measurement> getMeasurements();

    public Measurement getByIndex(int var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public double getOrDefault(String name, double defaultValue) {
        MeasurementList measurementList = this;
        synchronized (measurementList) {
            double val = this.get(name);
            if (Double.isNaN(val)) {
                if (Double.isNaN(defaultValue) || this.containsKey(name)) {
                    return val;
                }
                return defaultValue;
            }
            return val;
        }
    }

    public double[] values();

    public double remove(String var1);

    default public void putAll(Map<String, ? extends Number> map) {
        for (Map.Entry<String, ? extends Number> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue().doubleValue());
        }
    }

    default public void putAll(MeasurementList list) {
        this.putAll(list.getMeasurements());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public void putAll(Collection<? extends Measurement> list) {
        MeasurementList measurementList = this;
        synchronized (measurementList) {
            for (Measurement measurement : list) {
                this.put(measurement.getName(), measurement.getValue());
            }
        }
    }

    default public Set<String> keySet() {
        List<String> names = this.getNames();
        Set<String> set = Set.copyOf(this.getNames());
        if (set.size() < names.size()) {
            LoggerFactory.getLogger(this.getClass()).warn("Duplicate measurement names detected! Set size {}, list size {}", (Object)set.size(), (Object)names.size());
        }
        return set;
    }

    public List<String> getNames();

    @Deprecated
    default public List<String> getMeasurementNames() {
        return this.getNames();
    }

    public double get(String var1);

    default public boolean containsKey(String name) {
        return this.getNames().contains(name);
    }

    default public boolean isEmpty() {
        return this.size() == 0;
    }

    default public int size() {
        return this.getNames().size();
    }

    @Override
    default public void close() {
    }

    public void removeAll(String ... var1);

    @Deprecated
    default public void removeMeasurements(String ... measurementNames) {
        this.removeAll(measurementNames);
    }

    public void clear();

    public Map<String, Number> asMap();

    public static enum MeasurementListType {
        GENERAL,
        DOUBLE,
        FLOAT;

    }
}

