/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.measurements;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import qupath.lib.measurements.Measurement;
import qupath.lib.measurements.MeasurementFactory;
import qupath.lib.measurements.MeasurementList;
import qupath.lib.measurements.MeasurementsMap;

class DefaultMeasurementList
implements MeasurementList {
    private static final long serialVersionUID = 1L;
    private ArrayList<Measurement> list;
    private volatile transient Map<String, Number> mapView;

    DefaultMeasurementList() {
        this.list = new ArrayList();
    }

    DefaultMeasurementList(int capacity) {
        this.list = new ArrayList(capacity);
    }

    @Override
    public synchronized void clear() {
        this.list.clear();
    }

    @Override
    public synchronized List<String> getNames() {
        return this.list.stream().map(Measurement::getName).toList();
    }

    @Override
    public List<Measurement> getMeasurements() {
        return List.copyOf(this.list);
    }

    @Override
    public Measurement getByIndex(int ind) {
        return this.list.get(ind);
    }

    @Override
    public synchronized double[] values() {
        return this.list.stream().mapToDouble(Measurement::getValue).toArray();
    }

    @Override
    public synchronized double remove(String name) {
        Iterator<Measurement> iter = this.list.iterator();
        while (iter.hasNext()) {
            Measurement next = iter.next();
            if (!next.getName().equals(name)) continue;
            iter.remove();
            return next.getValue();
        }
        return Double.NaN;
    }

    @Override
    public synchronized double get(String name) {
        for (Measurement m : this.list) {
            if (!m.getName().equals(name)) continue;
            return m.getValue();
        }
        return Double.NaN;
    }

    @Override
    public synchronized boolean containsKey(String measurement) {
        for (Measurement m : this.list) {
            if (!m.getName().equals(measurement)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    private void compactStorage() {
        this.list.trimToSize();
    }

    @Override
    public synchronized void close() {
        this.compactStorage();
    }

    @Override
    public synchronized void put(String name, double value) {
        Objects.requireNonNull(name, "Measurement name cannot be null");
        Measurement measurement = MeasurementFactory.createMeasurement(name, value);
        int ind = 0;
        for (Measurement m : this.list) {
            if (m.getName().equals(name)) break;
            ++ind;
        }
        if (ind < this.list.size()) {
            this.list.set(ind, measurement);
        } else {
            this.list.add(measurement);
        }
    }

    @Override
    public synchronized void removeAll(String ... measurementNames) {
        for (String name : measurementNames) {
            int ind = 0;
            for (Measurement m : this.list) {
                if (m.getName().equals(name)) break;
                ++ind;
            }
            if (ind >= this.list.size()) continue;
            this.list.remove(ind);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Number> asMap() {
        if (this.mapView == null) {
            DefaultMeasurementList defaultMeasurementList = this;
            synchronized (defaultMeasurementList) {
                if (this.mapView == null) {
                    this.mapView = Collections.synchronizedMap(new MeasurementsMap(this));
                }
            }
        }
        return this.mapView;
    }

    public synchronized String toString() {
        return "[" + this.list.stream().map(DefaultMeasurementList::toString).collect(Collectors.joining(", ")) + "]";
    }

    private static String toString(Measurement m) {
        return m.getName() + ": " + m.getValue();
    }
}

