/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.io;

import java.io.File;
import java.io.IOException;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.common.GeneralTools;
import qupath.lib.objects.TMACoreObject;
import qupath.lib.objects.hierarchy.PathObjectHierarchy;
import qupath.lib.objects.hierarchy.TMAGrid;

public class TMAScoreImporter {
    private static final Logger logger = LoggerFactory.getLogger(TMAScoreImporter.class);

    public static int importFromCSV(File file, PathObjectHierarchy hierarchy) throws IOException {
        return TMAScoreImporter.importFromCSV(TMAScoreImporter.readCSV(file), hierarchy);
    }

    public static int importFromCSV(String text, PathObjectHierarchy hierarchy) {
        return TMAScoreImporter.importFromCSV(TMAScoreImporter.readCSV(text), hierarchy);
    }

    private static int importFromCSV(Map<String, List<String>> map, PathObjectHierarchy hierarchy) {
        int i;
        TMAGrid tmaGrid = hierarchy.getTMAGrid();
        if (tmaGrid == null || tmaGrid.nCores() == 0) {
            logger.error("No TMA grid found!");
            return 0;
        }
        String coreKey = null;
        for (String key : map.keySet()) {
            if (!key.trim().toLowerCase().equals("core")) continue;
            coreKey = key;
            break;
        }
        List<String> coreNames = coreKey == null ? null : map.remove(coreKey);
        List<String> coreIDs = map.remove("Case ID");
        if (coreNames == null && coreIDs == null) {
            logger.error("No column with header 'core' or 'Case ID' found");
            return 0;
        }
        HashMap<Integer, List<Object>> cores = new HashMap<Integer, List<Object>>();
        boolean coresFound = false;
        if (coreIDs != null) {
            i = 0;
            for (String id : coreIDs) {
                ArrayList<TMACoreObject> coresByID = new ArrayList<TMACoreObject>();
                for (TMACoreObject coreTemp : tmaGrid.getTMACoreList()) {
                    if (id == null || !id.equals(coreTemp.getCaseID())) continue;
                    coresByID.add(coreTemp);
                }
                if (!coresByID.isEmpty()) {
                    cores.put(i, coresByID);
                    coresFound = true;
                    if (coreNames != null && coresByID.size() == 1) {
                        String currentName = ((TMACoreObject)coresByID.get(0)).getName();
                        String newName = coreNames.get(i);
                        if (!newName.equals(currentName)) {
                            ((TMACoreObject)coresByID.get(0)).setName(newName);
                            if (currentName != null) {
                                logger.warn("Core name changed from {} to {}", (Object)currentName, (Object)newName);
                            }
                        }
                    }
                }
                ++i;
            }
        }
        if (!coresFound && coreNames != null) {
            i = 0;
            for (String name : coreNames) {
                TMACoreObject core = tmaGrid.getTMACore(name);
                if (core != null) {
                    cores.put(i, Collections.singletonList(core));
                    coresFound = true;
                    if (coreIDs != null) {
                        String currentID = core.getCaseID();
                        String newID = coreIDs.get(i);
                        if (newID != null && !newID.equals(currentID)) {
                            core.setCaseID(newID);
                            if (currentID != null) {
                                logger.warn("Core unique ID changed from {} to {}", (Object)currentID, (Object)newID);
                            }
                        }
                    }
                }
                ++i;
            }
        }
        for (Map.Entry<String, List<String>> entry : map.entrySet()) {
            int i2;
            Iterator iterator;
            if (entry.getKey() == null || entry.getKey().trim().length() == 0) continue;
            boolean isOverallSurvival = entry.getKey().equalsIgnoreCase("Overall survival");
            boolean isRecurrenceFreeSurvival = entry.getKey().equalsIgnoreCase("Recurrence-free survival");
            boolean isOSCensored = entry.getKey().equalsIgnoreCase("OS censored");
            boolean isRFSCensored = entry.getKey().equalsIgnoreCase("RFS censored");
            boolean isSurvivalRelated = isOverallSurvival || isRecurrenceFreeSurvival || isOSCensored || isRFSCensored;
            double[] vals = TMAScoreImporter.parseNumeric(entry.getValue(), !isSurvivalRelated);
            if (isSurvivalRelated || vals == null || vals.length == GeneralTools.numNaNs(vals)) {
                iterator = cores.keySet().iterator();
                while (iterator.hasNext()) {
                    i2 = (Integer)iterator.next();
                    for (TMACoreObject core : (List)cores.get(i2)) {
                        if (core == null) continue;
                        if (isOverallSurvival) {
                            core.getMeasurementList().put("Overall survival", vals[i2]);
                            continue;
                        }
                        if (isRecurrenceFreeSurvival) {
                            core.getMeasurementList().put("Recurrence-free survival", vals[i2]);
                            continue;
                        }
                        if (isOSCensored) {
                            core.getMeasurementList().put("OS censored", vals[i2] > 0.0 ? 1.0 : 0.0);
                            continue;
                        }
                        if (isRFSCensored) {
                            core.getMeasurementList().put("RFS censored", vals[i2] > 0.0 ? 1.0 : 0.0);
                            continue;
                        }
                        core.putMetadataValue(entry.getKey(), entry.getValue().get(i2));
                    }
                }
                continue;
            }
            iterator = cores.keySet().iterator();
            while (iterator.hasNext()) {
                i2 = (Integer)iterator.next();
                for (TMACoreObject core : (List)cores.get(i2)) {
                    core.getMeasurementList().put(entry.getKey(), vals[i2]);
                }
            }
        }
        HashSet<TMACoreObject> changed = new HashSet<TMACoreObject>();
        for (List coreList : cores.values()) {
            for (TMACoreObject core : coreList) {
                if (core == null) continue;
                core.getMeasurementList().close();
                changed.add(core);
            }
        }
        hierarchy.fireObjectsChangedEvent(null, changed);
        return changed.size();
    }

    public static double[] parseNumeric(List<String> list, boolean allOrNothing) {
        double[] vals = new double[list.size()];
        int i = 0;
        NumberFormat format = NumberFormat.getInstance();
        for (String s : list) {
            block7: {
                if (s == null || s.trim().length() == 0) {
                    vals[i] = Double.NaN;
                } else {
                    try {
                        vals[i] = format.parse(s).doubleValue();
                    }
                    catch (ParseException e) {
                        try {
                            vals[i] = Double.parseDouble(s);
                        }
                        catch (NumberFormatException e2) {
                            vals[i] = Double.NaN;
                            if (!allOrNothing) break block7;
                            return null;
                        }
                    }
                }
            }
            ++i;
        }
        return vals;
    }

    public static Map<String, List<String>> readCSV(String text) {
        return TMAScoreImporter.readCSV(new Scanner(text));
    }

    public static Map<String, List<String>> readCSV(File file) throws IOException {
        try (Scanner scanner = new Scanner(file);){
            Map<String, List<String>> map = TMAScoreImporter.readCSV(scanner);
            return map;
        }
    }

    public static Map<String, List<String>> readCSV(Scanner scanner) {
        String delimiter = null;
        LinkedHashMap<String, List<String>> map = null;
        String line = scanner.nextLine();
        if (line == null) {
            return Collections.emptyMap();
        }
        delimiter = line.contains("\t") ? "\t" : ",";
        String[] columns = line.split(delimiter);
        map = new LinkedHashMap<String, List<String>>();
        for (String col : columns) {
            map.put(col, new ArrayList());
        }
        while (scanner.hasNextLine() && (line = scanner.nextLine()) != null) {
            if (line.trim().isEmpty()) continue;
            int counter = 0;
            String[] values = line.split(delimiter);
            for (String col : columns) {
                if (counter < values.length) {
                    ((List)map.get(col)).add(values[counter]);
                } else {
                    ((List)map.get(col)).add(null);
                }
                ++counter;
            }
        }
        return map;
    }
}

