/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.io;

import java.util.ArrayList;
import java.util.Collection;
import qupath.lib.objects.PathObject;

public class FeatureCollection {
    private Collection<? extends PathObject> pathObjects;
    private boolean includeChildren = false;

    private FeatureCollection(Collection<? extends PathObject> pathObjects, boolean includeChildren) {
        this.pathObjects = pathObjects;
        this.includeChildren = includeChildren;
    }

    public boolean getIncludeChildren() {
        return this.includeChildren;
    }

    public Collection<? extends PathObject> getPathObjects() {
        return this.pathObjects;
    }

    public static FeatureCollection wrap(Collection<? extends PathObject> pathObjects) {
        return FeatureCollection.wrap(pathObjects, false);
    }

    public static FeatureCollection wrap(Collection<? extends PathObject> pathObjects, boolean includeChildObjects) {
        if (includeChildObjects) {
            return new FeatureCollection(new ArrayList<PathObject>(pathObjects), includeChildObjects);
        }
        return new FeatureCollection(new ArrayList<PathObject>(pathObjects), includeChildObjects);
    }
}

