/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.images.writers;

import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import qupath.lib.images.servers.ImageServer;
import qupath.lib.images.servers.ImageServerMetadata;
import qupath.lib.images.writers.AbstractImageIOWriter;

public class PngWriter
extends AbstractImageIOWriter {
    @Override
    public String getName() {
        return "PNG";
    }

    @Override
    public Collection<String> getExtensions() {
        return Collections.singleton("png");
    }

    @Override
    public void writeImage(BufferedImage img, String pathOutput) throws IOException {
        if (img.getTransparency() == 2 && img.getColorModel() instanceof IndexColorModel) {
            IndexColorModel cm = (IndexColorModel)img.getColorModel();
            int n = cm.getMapSize();
            byte[] reds = new byte[n];
            byte[] greens = new byte[n];
            byte[] blues = new byte[n];
            cm.getReds(reds);
            cm.getGreens(greens);
            cm.getBlues(blues);
            IndexColorModel cmNew = new IndexColorModel(cm.getPixelSize(), n, reds, greens, blues);
            img = new BufferedImage(cmNew, img.getRaster(), cmNew.isAlphaPremultiplied(), null);
        }
        if (img.getType() == 0 && img.getRaster().getDataBuffer().getDataType() == 1) {
            int width = img.getWidth();
            int height = img.getHeight();
            BufferedImage imgShort = new BufferedImage(width, height, 11);
            WritableRaster shortRaster = imgShort.getRaster();
            shortRaster.setDataElements(0, 0, img.getRaster());
            img = imgShort;
        }
        super.writeImage(img, pathOutput);
    }

    @Override
    public String getDetails() {
        return "Write image as PNG using ImageIO (lossless compression). Only supports 8-bit single-channel or RGB images, and loses image metadata (e.g. pixel calibration).";
    }

    @Override
    public boolean supportsImageType(ImageServer<BufferedImage> server) {
        return super.supportsImageType(server) || PngWriter.isIndexedColor(server);
    }

    private static boolean isIndexedColor(ImageServer<BufferedImage> server) {
        return server.getMetadata().getChannelType() == ImageServerMetadata.ChannelType.CLASSIFICATION;
    }
}

