/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.images.writers;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import qupath.lib.images.writers.AbstractImageIOWriter;

public class JpegWriter
extends AbstractImageIOWriter {
    @Override
    public String getName() {
        return "JPEG";
    }

    @Override
    public String getDetails() {
        return "Write image as JPEG using ImageIO (lossy compression). Only supports 8-bit single-channel or RGB images, and loses image metadata (e.g. pixel calibration).";
    }

    @Override
    public void writeImage(BufferedImage img, String pathOutput) throws IOException {
        if (img.getTransparency() != 1) {
            BufferedImage img2 = new BufferedImage(img.getWidth(), img.getHeight(), 1);
            Graphics2D g2d = img2.createGraphics();
            g2d.drawImage((Image)img, 0, 0, null);
            g2d.dispose();
            img = img2;
        }
        super.writeImage(img, pathOutput);
    }

    @Override
    public Collection<String> getExtensions() {
        return Arrays.asList("jpg", "jpeg");
    }
}

