/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.images.writers;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ServiceLoader;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.common.GeneralTools;
import qupath.lib.images.servers.ImageServer;
import qupath.lib.images.servers.WrappedBufferedImageServer;
import qupath.lib.images.writers.ImageWriter;
import qupath.lib.regions.RegionRequest;

public class ImageWriterTools {
    private static final Logger logger = LoggerFactory.getLogger(ImageWriterTools.class);
    private static Comparator<ImageWriter<?>> COMPARATOR = Comparator.comparing(writer -> writer.supportsPixelSize()).thenComparing(ImageWriter::supportsZ).thenComparing(ImageWriter::supportsT).thenComparing(ImageWriter::supportsPyramidal).thenComparing(ImageWriter::supportsRGB).thenComparing(ImageWriter::getName);

    public static <T> List<ImageWriter<T>> getCompatibleWriters(ImageServer<T> server, String ext) {
        if (server == null) {
            return ImageWriterTools.getCompatibleWriters((Class)null, ext);
        }
        List<ImageWriter<T>> writers = ImageWriterTools.getCompatibleWriters(server.getImageClass(), ext);
        return writers.stream().filter(w -> w.supportsImageType(server)).toList();
    }

    public static <T> List<ImageWriter<T>> getCompatibleWriters(Class<T> imageClass, String ext) {
        String ext2;
        if (ext == null) {
            ext2 = null;
        } else {
            ext2 = ext.trim();
            ext2 = ext2.startsWith("*") ? ext2.substring(1) : ext2;
            ext2 = ext2.startsWith(".") ? ext2.substring(1) : ext2;
        }
        ArrayList<ImageWriter<T>> writers = new ArrayList<ImageWriter<T>>();
        for (ImageWriter writer : ServiceLoader.load(ImageWriter.class)) {
            if (imageClass != null && !imageClass.equals(writer.getImageClass()) || ext2 != null && !writer.getExtensions().contains(ext2)) continue;
            writers.add(writer);
        }
        Collections.sort(writers, COMPARATOR);
        return writers;
    }

    public static boolean writeImageRegion(ImageServer<BufferedImage> server, RegionRequest request, String path) throws IOException {
        String ext = GeneralTools.getExtension(new File(path)).orElse(null);
        List<ImageWriter<BufferedImage>> compatibleWriters = ImageWriterTools.getCompatibleWriters(server, ext);
        for (ImageWriter<BufferedImage> writer : compatibleWriters) {
            try {
                writer.writeImage(server, request, path);
                return true;
            }
            catch (Exception e) {
                logger.warn("Unable to write image", (Throwable)e);
            }
        }
        throw new IOException("Unable to write " + path + "!  No compatible writer found.");
    }

    public static boolean writeImage(BufferedImage img, String path) throws IOException {
        String ext = GeneralTools.getExtension(new File(path)).orElse(null);
        List<ImageWriter<BufferedImage>> compatibleWriters = ImageWriterTools.getCompatibleWriters(new WrappedBufferedImageServer(UUID.randomUUID().toString(), img), ext);
        for (ImageWriter<BufferedImage> writer : compatibleWriters) {
            try {
                writer.writeImage(img, path);
                return true;
            }
            catch (Exception e) {
                logger.warn("Unable to write image", (Throwable)e);
            }
        }
        throw new IOException("Unable to write " + path + "!  No compatible writer found.");
    }

    public static boolean writeImage(ImageServer<BufferedImage> server, String path) throws IOException {
        String ext = GeneralTools.getExtension(new File(path)).orElse(null);
        List<ImageWriter<BufferedImage>> compatibleWriters = ImageWriterTools.getCompatibleWriters(server, ext);
        Exception firstException = null;
        for (ImageWriter<BufferedImage> writer : compatibleWriters) {
            try {
                writer.writeImage(server, path);
                return true;
            }
            catch (Exception e) {
                logger.warn("Unable to write image", (Throwable)e);
                firstException = e;
            }
        }
        if (firstException == null) {
            throw new IOException("Unable to write " + path + "!  No compatible writer found.");
        }
        throw new IOException("Unable to write " + path + "!", firstException);
    }
}

