/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.images.servers.transforms;

import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import qupath.lib.common.GeneralTools;
import qupath.lib.images.servers.transforms.BufferedImageNormalizer;

public class SubtractOffsetAndScaleNormalizer
implements BufferedImageNormalizer {
    private final double[] offsets;
    private final double[] scales;
    private final double minClip;
    private final double maxClip;

    private SubtractOffsetAndScaleNormalizer(double[] offsets, double[] scales, double minClip, double maxClip) {
        this.scales = scales == null ? null : (double[])scales.clone();
        this.offsets = offsets == null ? null : (double[])offsets.clone();
        this.minClip = minClip;
        this.maxClip = maxClip;
    }

    public static SubtractOffsetAndScaleNormalizer createScaled(double ... scales) {
        return SubtractOffsetAndScaleNormalizer.createWithClipRange(null, scales, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
    }

    public static SubtractOffsetAndScaleNormalizer createSubtractOffset(double ... offsets) {
        return SubtractOffsetAndScaleNormalizer.createWithClipRange(offsets, null, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
    }

    public static SubtractOffsetAndScaleNormalizer createSubtractOffsetAndClipZero(double ... offsets) {
        return SubtractOffsetAndScaleNormalizer.createWithClipRange(offsets, null, 0.0, Double.POSITIVE_INFINITY);
    }

    public static SubtractOffsetAndScaleNormalizer create(double[] offsets, double[] scales) {
        return SubtractOffsetAndScaleNormalizer.createWithClipRange(offsets, scales, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
    }

    public static SubtractOffsetAndScaleNormalizer createWithClipRange(double[] offsets, double[] scales, double minClip, double maxClip) {
        return new SubtractOffsetAndScaleNormalizer(offsets, scales, minClip, maxClip);
    }

    @Override
    public BufferedImage filter(BufferedImage img, BufferedImage output) {
        if (output == null) {
            output = this.createCompatibleDestImage(img, img.getColorModel());
        }
        WritableRaster raster = img.getRaster();
        int w = img.getWidth();
        int h = img.getHeight();
        double[] pixels = null;
        WritableRaster outputRaster = output.getRaster();
        double minClip = this.getMinClip(outputRaster.getDataBuffer().getDataType());
        double maxClip = this.getMaxClip(outputRaster.getDataBuffer().getDataType());
        boolean doRounding = this.isIntegerType(outputRaster.getDataBuffer().getDataType());
        for (int b = 0; b < raster.getNumBands(); ++b) {
            pixels = raster.getSamples(0, 0, w, h, b, pixels);
            double offset = this.offsetForChannel(b);
            double scale = this.scaleForChannel(b);
            if (offset != 0.0 || scale != 1.0) {
                for (int i = 0; i < pixels.length; ++i) {
                    double val = GeneralTools.clipValue((pixels[i] - offset) * scale, minClip, maxClip);
                    if (doRounding) {
                        val = Math.round(val);
                    }
                    pixels[i] = val;
                }
            }
            outputRaster.setSamples(0, 0, w, h, b, pixels);
        }
        return output;
    }

    boolean isIntegerType(int dataType) {
        switch (dataType) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return true;
            }
        }
        return false;
    }

    double getMinClip(int dataType) {
        switch (dataType) {
            case 0: 
            case 1: {
                return Math.max(0.0, this.minClip);
            }
            case 3: {
                return Math.max(-2.147483648E9, this.minClip);
            }
            case 2: {
                return Math.max(-32768.0, this.minClip);
            }
        }
        return this.minClip;
    }

    double getMaxClip(int dataType) {
        switch (dataType) {
            case 0: {
                return Math.min(255.0, this.maxClip);
            }
            case 1: {
                return Math.min(65535.0, this.maxClip);
            }
            case 3: {
                return Math.min(2.147483647E9, this.maxClip);
            }
            case 2: {
                return Math.min(32767.0, this.maxClip);
            }
        }
        return this.maxClip;
    }

    private double scaleForChannel(int channel) {
        if (this.scales == null) {
            return 1.0;
        }
        if (channel < this.scales.length) {
            return this.scales[channel];
        }
        if (this.scales.length == 1) {
            return this.scales[0];
        }
        throw new IllegalArgumentException("Channel index out of bounds: " + channel);
    }

    private double offsetForChannel(int channel) {
        if (this.offsets == null) {
            return 0.0;
        }
        if (channel < this.offsets.length) {
            return this.offsets[channel];
        }
        if (this.offsets.length == 1) {
            return this.offsets[0];
        }
        throw new IllegalArgumentException("Channel index out of bounds: " + channel);
    }
}

