/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.images.servers.transforms;

import java.awt.image.BufferedImage;
import qupath.lib.awt.common.BufferedImageTools;
import qupath.lib.color.ColorDeconvolutionStains;
import qupath.lib.color.ColorTransformer;
import qupath.lib.images.servers.transforms.BufferedImageNormalizer;

public class ColorDeconvolutionNormalizer
implements BufferedImageNormalizer {
    private final ColorDeconvolutionStains stainsInput;
    private final ColorDeconvolutionStains stainsOutput;
    private final double[] scales;

    private ColorDeconvolutionNormalizer(ColorDeconvolutionStains stainsInput, ColorDeconvolutionStains stainsOutput, double[] scales) {
        this.stainsInput = stainsInput;
        this.stainsOutput = stainsOutput;
        this.scales = scales == null || scales.length == 0 ? null : (double[])scales.clone();
    }

    public static ColorDeconvolutionNormalizer create(ColorDeconvolutionStains stainsInput, ColorDeconvolutionStains stainsOutput, double ... scales) {
        return new ColorDeconvolutionNormalizer(stainsInput, stainsOutput, scales);
    }

    @Override
    public BufferedImage filter(BufferedImage img, BufferedImage output) {
        if (output == null) {
            output = this.createCompatibleDestImage(img, null);
        }
        if (!BufferedImageTools.is8bitColorType(img.getType()) || !BufferedImageTools.is8bitColorType(output.getType())) {
            throw new IllegalArgumentException("Color deconvolution normalizer only supports 8-bit RGB inputs and outputs");
        }
        int[] rgb = img.getRGB(0, 0, img.getWidth(), img.getHeight(), null, 0, img.getWidth());
        ColorTransformer.colorDeconvolveReconvolveRGBArray(rgb, this.stainsInput, this.stainsOutput, rgb, this.scales);
        output.setRGB(0, 0, img.getWidth(), img.getHeight(), rgb, 0, img.getWidth());
        return output;
    }
}

