/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.images.servers.transforms;

import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.util.Objects;
import qupath.lib.awt.common.BufferedImageTools;

public interface BufferedImageNormalizer
extends BufferedImageOp {
    @Override
    default public Rectangle2D getBounds2D(BufferedImage src) {
        return new Rectangle(src.getRaster().getBounds());
    }

    @Override
    default public BufferedImage createCompatibleDestImage(BufferedImage src, ColorModel destCM) {
        if (BufferedImageTools.is8bitColorType(src.getType()) && (destCM == null || Objects.equals(destCM, ColorModel.getRGBdefault()))) {
            return new BufferedImage(src.getWidth(), src.getHeight(), src.getType());
        }
        if (destCM == null) {
            destCM = src.getColorModel();
        }
        return new BufferedImage(destCM, destCM.createCompatibleWritableRaster(src.getWidth(), src.getHeight()), destCM.isAlphaPremultiplied(), null);
    }

    @Override
    default public Point2D getPoint2D(Point2D srcPt, Point2D dstPt) {
        return new Point2D.Double(srcPt.getX(), srcPt.getY());
    }

    @Override
    default public RenderingHints getRenderingHints() {
        return null;
    }
}

