/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.images.servers.downsamples;

import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.images.servers.ImageServer;
import qupath.lib.images.servers.PixelCalibration;
import qupath.lib.images.servers.downsamples.DownsampleCalculator;
import qupath.lib.regions.ImageRegion;

class PixelCalibrationDownsampleCalculator
implements DownsampleCalculator {
    private static final Logger logger = LoggerFactory.getLogger(PixelCalibrationDownsampleCalculator.class);
    private final PixelCalibration targetCalibration;

    PixelCalibrationDownsampleCalculator(PixelCalibration targetCalibration) {
        this.targetCalibration = targetCalibration;
    }

    @Override
    public double getDownsample(ImageServer<?> server, ImageRegion region) {
        PixelCalibration cal = server.getPixelCalibration();
        if (!this.unitsMatch(cal)) {
            logger.warn("Unmatched pixel width & height units - expected {}, {} but found {}, {}", new Object[]{this.targetCalibration.getPixelWidthUnit(), this.targetCalibration.getPixelHeightUnit(), cal.getPixelWidthUnit(), cal.getPixelHeightUnit()});
        }
        return this.targetCalibration.getAveragedPixelSize().doubleValue() / cal.getAveragedPixelSize().doubleValue();
    }

    private boolean unitsMatch(PixelCalibration newCal) {
        return Objects.equals(newCal.getPixelWidthUnit(), this.targetCalibration.getPixelWidthUnit()) && !Objects.equals(newCal.getPixelHeightUnit(), this.targetCalibration.getPixelHeightUnit());
    }

    public String toString() {
        return "PixelCalibrationDownsampleCalculator[target=" + String.valueOf(this.targetCalibration.getAveragedPixelSize()) + "]";
    }
}

