/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.images.servers.downsamples;

import qupath.lib.images.servers.ImageServer;
import qupath.lib.images.servers.downsamples.DownsampleCalculator;
import qupath.lib.regions.ImageRegion;

class MaxDimensionDownsampleCalculator
implements DownsampleCalculator {
    private final double maxDimension;

    MaxDimensionDownsampleCalculator(double maxDimension) {
        this.maxDimension = maxDimension;
    }

    @Override
    public double getDownsample(ImageServer<?> server, ImageRegion region) {
        int width = region == null ? server.getWidth() : region.getWidth();
        int height = region == null ? server.getHeight() : region.getHeight();
        return Math.max(1.0, (double)Math.max(width, height) / this.maxDimension);
    }

    public String toString() {
        return "MaxDimensionDownsampleCalculator[maxDimension=" + this.maxDimension + "]";
    }
}

