/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.images.servers.downsamples;

import com.google.gson.TypeAdapterFactory;
import qupath.lib.images.servers.PixelCalibration;
import qupath.lib.images.servers.downsamples.DownsampleCalculator;
import qupath.lib.images.servers.downsamples.FixedDownsampleCalculator;
import qupath.lib.images.servers.downsamples.MaxDimensionDownsampleCalculator;
import qupath.lib.images.servers.downsamples.PixelCalibrationDownsampleCalculator;
import qupath.lib.io.GsonTools;

public class DownsampleCalculators {
    private static final TypeAdapterFactory factory = GsonTools.createSubTypeAdapterFactory(DownsampleCalculator.class, "downsampleType").registerSubtype(MaxDimensionDownsampleCalculator.class, "maxDim").registerSubtype(FixedDownsampleCalculator.class, "fixed").registerSubtype(PixelCalibrationDownsampleCalculator.class, "pixelSize");

    public static DownsampleCalculator maxDimension(int maxDimension) {
        return new MaxDimensionDownsampleCalculator(maxDimension);
    }

    public static DownsampleCalculator fixedDownsample(double downsample) {
        return new FixedDownsampleCalculator(downsample);
    }

    public static DownsampleCalculator pixelSizeMicrons(double pixelSizeMicrons) {
        PixelCalibration cal = new PixelCalibration.Builder().pixelSizeMicrons(pixelSizeMicrons, pixelSizeMicrons).build();
        return DownsampleCalculators.pixelSize(cal);
    }

    public static DownsampleCalculator pixelSize(PixelCalibration targetPixelSize) {
        return new PixelCalibrationDownsampleCalculator(targetPixelSize);
    }

    static {
        GsonTools.getDefaultBuilder().registerTypeAdapterFactory(factory);
    }
}

