/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.images.servers;

import java.awt.image.BandedSampleModel;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import qupath.lib.color.ColorModelFactory;
import qupath.lib.common.ColorTools;
import qupath.lib.images.servers.AbstractTileableImageServer;
import qupath.lib.images.servers.ImageServer;
import qupath.lib.images.servers.ImageServerBuilder;
import qupath.lib.images.servers.ImageServerMetadata;
import qupath.lib.images.servers.ImageServers;
import qupath.lib.images.servers.PixelType;
import qupath.lib.images.servers.TileRequest;
import qupath.lib.regions.RegionRequest;

public class ZProjectedImageServer
extends AbstractTileableImageServer {
    private final ImageServer<BufferedImage> server;
    private final Projection projection;
    private final ImageServerMetadata metadata;
    public static final int NO_RUNNING_OFFSET = -1;
    private final int runningOffset;

    ZProjectedImageServer(ImageServer<BufferedImage> server, Projection projection) {
        this(server, projection, -1);
    }

    ZProjectedImageServer(ImageServer<BufferedImage> server, Projection projection, int runningOffset) {
        if (List.of(PixelType.INT8, PixelType.UINT32).contains((Object)server.getMetadata().getPixelType())) {
            throw new IllegalArgumentException(String.format("The provided pixel type %s is not supported", new Object[]{server.getMetadata().getPixelType()}));
        }
        this.server = server;
        this.projection = projection;
        this.runningOffset = runningOffset;
        PixelType pixelType = projection.equals((Object)Projection.SUM) && !server.getMetadata().isRGB() && List.of(PixelType.UINT8, PixelType.INT8, PixelType.UINT16, PixelType.INT16).contains((Object)server.getMetadata().getPixelType()) ? PixelType.FLOAT32 : server.getMetadata().getPixelType();
        this.metadata = new ImageServerMetadata.Builder(server.getMetadata()).pixelType(pixelType).sizeZ(runningOffset >= 0 ? server.nZSlices() : 1).build();
    }

    @Override
    protected ImageServerBuilder.ServerBuilder<BufferedImage> createServerBuilder() {
        return new ImageServers.ZProjectedImageServerBuilder(this.getMetadata(), this.server.getBuilder(), this.projection, this.runningOffset);
    }

    @Override
    protected String createID() {
        return String.format("%s with %s projection on %s (group offset=%d)", new Object[]{this.getClass().getName(), this.projection, this.server.getPath(), this.runningOffset});
    }

    @Override
    protected BufferedImage readTile(TileRequest tileRequest) throws IOException {
        if (this.getMetadata().isRGB()) {
            return this.getRgbTile(tileRequest);
        }
        return this.getNonRgbTile(tileRequest);
    }

    @Override
    public Collection<URI> getURIs() {
        return this.server.getURIs();
    }

    @Override
    public String getServerType() {
        return String.format("%s projection image server", new Object[]{this.projection});
    }

    @Override
    public ImageServerMetadata getOriginalMetadata() {
        return this.metadata;
    }

    private BufferedImage getRgbTile(TileRequest tileRequest) throws IOException {
        int width = tileRequest.getTileWidth();
        int height = tileRequest.getTileHeight();
        ArrayList<int[]> zStacks = new ArrayList<int[]>();
        RegionRequest region = tileRequest.getRegionRequest().updatePath(this.server.getPath());
        for (int z = 0; z < this.server.getMetadata().getSizeZ(); ++z) {
            zStacks.add(this.server.readRegion(region.updateZ(z)).getRGB(0, 0, width, height, null, 0, width));
        }
        BufferedImage image = this.createDefaultRGBImage(width, height);
        int sizeZ = this.server.nZSlices();
        int numberOfPixels = width * height;
        image.setRGB(0, 0, width, height, switch (this.projection.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> ZProjectedImageServer.getRgbMeanProjection(numberOfPixels, sizeZ, zStacks);
            case 1 -> ZProjectedImageServer.getRgbMinProjection(numberOfPixels, sizeZ, zStacks);
            case 2 -> ZProjectedImageServer.getRgbMaxProjection(numberOfPixels, sizeZ, zStacks);
            case 3 -> ZProjectedImageServer.getRgbSumProjection(numberOfPixels, sizeZ, zStacks);
            case 4 -> ZProjectedImageServer.getRgbStandardDeviationProjection(numberOfPixels, sizeZ, zStacks, this.getMetadata().getSizeC() == 4);
            case 5 -> ZProjectedImageServer.getRgbMedianProjection(numberOfPixels, sizeZ, zStacks);
        }, 0, width);
        return image;
    }

    private static int[] getRgbMeanProjection(int numberOfPixels, int sizeZ, List<int[]> zStacks) {
        int[] argb = new int[numberOfPixels];
        for (int i = 0; i < numberOfPixels; ++i) {
            int sumAlpha = 0;
            int sumRed = 0;
            int sumGreen = 0;
            int sumBlue = 0;
            for (int z = 0; z < sizeZ; ++z) {
                int zValue = zStacks.get(z)[i];
                sumAlpha += ColorTools.alpha(zValue);
                sumRed += ColorTools.red(zValue);
                sumGreen += ColorTools.green(zValue);
                sumBlue += ColorTools.blue(zValue);
            }
            argb[i] = (Math.round((float)sumAlpha / (float)sizeZ) & 0xFF) << 24 | (Math.round((float)sumRed / (float)sizeZ) & 0xFF) << 16 | (Math.round((float)sumGreen / (float)sizeZ) & 0xFF) << 8 | Math.round((float)sumBlue / (float)sizeZ) & 0xFF;
        }
        return argb;
    }

    private static int[] getRgbMinProjection(int numberOfPixels, int sizeZ, List<int[]> zStacks) {
        int[] argb = new int[numberOfPixels];
        for (int i = 0; i < numberOfPixels; ++i) {
            int minAlpha = Integer.MAX_VALUE;
            int minRed = Integer.MAX_VALUE;
            int minGreen = Integer.MAX_VALUE;
            int minBlue = Integer.MAX_VALUE;
            for (int z = 0; z < sizeZ; ++z) {
                int zValue = zStacks.get(z)[i];
                minAlpha = Math.min(minAlpha, ColorTools.alpha(zValue));
                minRed = Math.min(minRed, ColorTools.red(zValue));
                minGreen = Math.min(minGreen, ColorTools.green(zValue));
                minBlue = Math.min(minBlue, ColorTools.blue(zValue));
            }
            argb[i] = (minAlpha & 0xFF) << 24 | (minRed & 0xFF) << 16 | (minGreen & 0xFF) << 8 | minBlue & 0xFF;
        }
        return argb;
    }

    private static int[] getRgbMaxProjection(int numberOfPixels, int sizeZ, List<int[]> zStacks) {
        int[] argb = new int[numberOfPixels];
        for (int i = 0; i < numberOfPixels; ++i) {
            int maxAlpha = Integer.MIN_VALUE;
            int maxRed = Integer.MIN_VALUE;
            int maxGreen = Integer.MIN_VALUE;
            int maxBlue = Integer.MIN_VALUE;
            for (int z = 0; z < sizeZ; ++z) {
                int zValue = zStacks.get(z)[i];
                maxAlpha = Math.max(maxAlpha, ColorTools.alpha(zValue));
                maxRed = Math.max(maxRed, ColorTools.red(zValue));
                maxGreen = Math.max(maxGreen, ColorTools.green(zValue));
                maxBlue = Math.max(maxBlue, ColorTools.blue(zValue));
            }
            argb[i] = (maxAlpha & 0xFF) << 24 | (maxRed & 0xFF) << 16 | (maxGreen & 0xFF) << 8 | maxBlue & 0xFF;
        }
        return argb;
    }

    private static int[] getRgbSumProjection(int numberOfPixels, int sizeZ, List<int[]> zStacks) {
        int[] argb = new int[numberOfPixels];
        for (int i = 0; i < numberOfPixels; ++i) {
            int sumAlpha = 0;
            int sumRed = 0;
            int sumGreen = 0;
            int sumBlue = 0;
            for (int z = 0; z < sizeZ; ++z) {
                int zValue = zStacks.get(z)[i];
                sumAlpha += ColorTools.alpha(zValue);
                sumRed += ColorTools.red(zValue);
                sumGreen += ColorTools.green(zValue);
                sumBlue += ColorTools.blue(zValue);
            }
            argb[i] = (Math.min(sumAlpha, 255) & 0xFF) << 24 | (Math.min(sumRed, 255) & 0xFF) << 16 | (Math.min(sumGreen, 255) & 0xFF) << 8 | Math.min(sumBlue, 255) & 0xFF;
        }
        return argb;
    }

    private static int[] getRgbStandardDeviationProjection(int numberOfPixels, int sizeZ, List<int[]> zStacks, boolean computeAlpha) {
        int[] argb = new int[numberOfPixels];
        for (int i = 0; i < numberOfPixels; ++i) {
            int[][] argbValues = new int[sizeZ][4];
            for (int z = 0; z < sizeZ; ++z) {
                int zValue = zStacks.get(z)[i];
                argbValues[z][0] = ColorTools.alpha(zValue);
                argbValues[z][1] = ColorTools.red(zValue);
                argbValues[z][2] = ColorTools.green(zValue);
                argbValues[z][3] = ColorTools.blue(zValue);
            }
            int sumAlpha = 0;
            int sumRed = 0;
            int sumGreen = 0;
            int sumBlue = 0;
            for (int z = 0; z < sizeZ; ++z) {
                sumAlpha += argbValues[z][0];
                sumRed += argbValues[z][1];
                sumGreen += argbValues[z][2];
                sumBlue += argbValues[z][3];
            }
            float meanAlpha = (float)sumAlpha / (float)sizeZ;
            float meanRed = (float)sumRed / (float)sizeZ;
            float meanGreen = (float)sumGreen / (float)sizeZ;
            float meanBlue = (float)sumBlue / (float)sizeZ;
            float varianceAlpha = 0.0f;
            float varianceRed = 0.0f;
            float varianceGreen = 0.0f;
            float varianceBlue = 0.0f;
            for (int z = 0; z < sizeZ; ++z) {
                varianceAlpha += (float)Math.pow((float)argbValues[z][0] - meanAlpha, 2.0);
                varianceRed += (float)Math.pow((float)argbValues[z][1] - meanRed, 2.0);
                varianceGreen += (float)Math.pow((float)argbValues[z][2] - meanGreen, 2.0);
                varianceBlue += (float)Math.pow((float)argbValues[z][3] - meanBlue, 2.0);
            }
            varianceAlpha *= 1.0f / (float)sizeZ;
            varianceRed *= 1.0f / (float)sizeZ;
            varianceGreen *= 1.0f / (float)sizeZ;
            varianceBlue *= 1.0f / (float)sizeZ;
            if (!computeAlpha) {
                varianceAlpha = (float)Math.pow(255.0, 2.0);
            }
            argb[i] = (Math.round((float)Math.sqrt(varianceAlpha)) & 0xFF) << 24 | (Math.round((float)Math.sqrt(varianceRed)) & 0xFF) << 16 | (Math.round((float)Math.sqrt(varianceGreen)) & 0xFF) << 8 | Math.round((float)Math.sqrt(varianceBlue)) & 0xFF;
        }
        return argb;
    }

    private static int[] getRgbMedianProjection(int numberOfPixels, int sizeZ, List<int[]> zStacks) {
        int[] argb = new int[numberOfPixels];
        for (int i = 0; i < numberOfPixels; ++i) {
            int[] zValuesAlpha = new int[sizeZ];
            int[] zValuesRed = new int[sizeZ];
            int[] zValuesGreen = new int[sizeZ];
            int[] zValuesBlue = new int[sizeZ];
            for (int z = 0; z < sizeZ; ++z) {
                int zValue = zStacks.get(z)[i];
                zValuesAlpha[z] = ColorTools.alpha(zValue);
                zValuesRed[z] = ColorTools.red(zValue);
                zValuesGreen[z] = ColorTools.green(zValue);
                zValuesBlue[z] = ColorTools.blue(zValue);
            }
            Arrays.sort(zValuesAlpha);
            Arrays.sort(zValuesRed);
            Arrays.sort(zValuesGreen);
            Arrays.sort(zValuesBlue);
            int medianAlpha = zValuesAlpha.length % 2 == 0 ? Math.round((float)(zValuesAlpha[zValuesAlpha.length / 2] + zValuesAlpha[zValuesAlpha.length / 2 - 1]) / 2.0f) : zValuesAlpha[zValuesAlpha.length / 2];
            int medianRed = zValuesRed.length % 2 == 0 ? Math.round((float)(zValuesRed[zValuesRed.length / 2] + zValuesRed[zValuesRed.length / 2 - 1]) / 2.0f) : zValuesRed[zValuesRed.length / 2];
            int medianGreen = zValuesGreen.length % 2 == 0 ? Math.round((float)(zValuesGreen[zValuesGreen.length / 2] + zValuesGreen[zValuesGreen.length / 2 - 1]) / 2.0f) : zValuesGreen[zValuesGreen.length / 2];
            int medianBlue = zValuesBlue.length % 2 == 0 ? Math.round((float)(zValuesBlue[zValuesBlue.length / 2] + zValuesBlue[zValuesBlue.length / 2 - 1]) / 2.0f) : zValuesBlue[zValuesBlue.length / 2];
            argb[i] = (medianAlpha & 0xFF) << 24 | (medianRed & 0xFF) << 16 | (medianGreen & 0xFF) << 8 | medianBlue & 0xFF;
        }
        return argb;
    }

    private Projector getProjector(Projection projection) {
        return switch (projection.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> new MeanProjector();
            case 1 -> new MinProjector();
            case 2 -> new MaxProjector();
            case 3 -> new SumProjector();
            case 4 -> new StdDevProjector();
            case 5 -> new MedianProjector();
        };
    }

    private BufferedImage getNonRgbTile(TileRequest tileRequest) throws IOException {
        ArrayList zStacks = new ArrayList();
        int zStart = 0;
        int zEnd = this.server.nZSlices();
        if (this.runningOffset >= 0) {
            zStart = Math.max(0, tileRequest.getZ() - this.runningOffset);
            zEnd = Math.min(this.server.nZSlices(), tileRequest.getZ() + this.runningOffset + 1);
        }
        DataBuffer dataBuffer = this.createDataBuffer(tileRequest, zStart, zEnd);
        return new BufferedImage(ColorModelFactory.createColorModel(this.getMetadata().getPixelType(), this.getMetadata().getChannels()), WritableRaster.createWritableRaster(new BandedSampleModel(dataBuffer.getDataType(), this.getWidth(), this.getHeight(), this.nChannels()), dataBuffer, null), false, null);
    }

    /*
     * Exception decompiling
     */
    private DataBuffer createDataBuffer(TileRequest tile, int zStart, int zEnd) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.ClassCastException: class org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement cannot be cast to class org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement (org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement and org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement are in unnamed module of loader 'app')
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchExpressionRewriter$LValueSingleUsageCheckingRewriter.rewriteExpression(SwitchExpressionRewriter.java:96)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.LValueExpression.applyExpressionRewriter(LValueExpression.java:84)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.AbstractExpressionRewriter.rewriteExpression(AbstractExpressionRewriter.java:14)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.AssignmentSimple.rewriteExpressions(AssignmentSimple.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredFor.rewriteExpressions(StructuredFor.java:194)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.transformers.ExpressionRewriterTransformer.transform(ExpressionRewriterTransformer.java:24)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.transformStructuredChildren(Block.java:421)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.transformers.ExpressionRewriterTransformer.transform(ExpressionRewriterTransformer.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchExpressionRewriter.rewriteBlockSwitches(SwitchExpressionRewriter.java:140)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchExpressionRewriter.transform(SwitchExpressionRewriter.java:71)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.switchExpression(Op04StructuredStatement.java:101)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:909)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static /* synthetic */ Projector[] lambda$createDataBuffer$1(int x$0) {
        return new Projector[x$0];
    }

    private /* synthetic */ Projector lambda$createDataBuffer$0(int c) {
        return this.getProjector(this.projection);
    }

    public static enum Projection {
        MEAN,
        MIN,
        MAX,
        SUM,
        STANDARD_DEVIATION,
        MEDIAN;

    }

    private static class MeanProjector
    extends SumProjector {
        private int n = 0;

        private MeanProjector() {
        }

        @Override
        public void accumulate(double[] values) {
            ++this.n;
            super.accumulate(values);
        }

        @Override
        public double getResult(int i) {
            return super.getResult(i) / (double)this.n;
        }
    }

    private static class MinProjector
    implements Projector {
        private double[] results;

        private MinProjector() {
        }

        @Override
        public void accumulate(double[] values) {
            if (this.results == null) {
                this.results = (double[])values.clone();
            } else {
                for (int i = 0; i < values.length; ++i) {
                    this.results[i] = Math.min(this.results[i], values[i]);
                }
            }
        }

        @Override
        public double getResult(int i) {
            return this.results[i];
        }
    }

    private static class MaxProjector
    implements Projector {
        private double[] results;

        private MaxProjector() {
        }

        @Override
        public void accumulate(double[] values) {
            if (this.results == null) {
                this.results = (double[])values.clone();
            } else {
                for (int i = 0; i < values.length; ++i) {
                    this.results[i] = Math.max(this.results[i], values[i]);
                }
            }
        }

        @Override
        public double getResult(int i) {
            return this.results[i];
        }
    }

    private static class SumProjector
    implements Projector {
        private double[] results;

        private SumProjector() {
        }

        @Override
        public void accumulate(double[] values) {
            if (this.results == null) {
                this.results = (double[])values.clone();
            } else {
                for (int i = 0; i < values.length; ++i) {
                    int n = i;
                    this.results[n] = this.results[n] + values[i];
                }
            }
        }

        @Override
        public double getResult(int i) {
            return this.results[i];
        }
    }

    private static class StdDevProjector
    extends SumProjector {
        private double[] sum;
        private double[] sumOfSquares;
        private int n;

        private StdDevProjector() {
        }

        @Override
        public void accumulate(double[] values) {
            ++this.n;
            if (this.sum == null) {
                this.sum = (double[])values.clone();
                this.sumOfSquares = new double[values.length];
                int i = 0;
                while (i < values.length) {
                    double v = values[i];
                    int n = i++;
                    this.sumOfSquares[n] = this.sumOfSquares[n] + v * v;
                }
            } else {
                int i = 0;
                while (i < values.length) {
                    double v = values[i];
                    int n = i;
                    this.sum[n] = this.sum[n] + v;
                    int n2 = i++;
                    this.sumOfSquares[n2] = this.sumOfSquares[n2] + v * v;
                }
            }
        }

        @Override
        public double getResult(int i) {
            double mean = this.sum[i] / (double)this.n;
            return Math.sqrt(this.sumOfSquares[i] / (double)this.n - mean * mean);
        }
    }

    private static class MedianProjector
    implements Projector {
        private final List<double[]> allValues = new ArrayList<double[]>();
        private double[] cache;

        private MedianProjector() {
        }

        @Override
        public void accumulate(double[] values) {
            this.allValues.add((double[])values.clone());
        }

        @Override
        public double getResult(int i) {
            int n = this.allValues.size();
            if (this.cache == null || this.cache.length != n) {
                this.cache = new double[n];
            }
            for (int j = 0; j < n; ++j) {
                this.cache[j] = this.allValues.get(j)[i];
            }
            Arrays.sort(this.cache);
            if (n % 2 == 0) {
                return (this.cache[n / 2] + this.cache[n / 2 - 1]) / 2.0;
            }
            return this.cache[n / 2];
        }
    }

    private static interface Projector {
        public void accumulate(double[] var1);

        public double getResult(int var1);
    }
}

