/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.images.servers;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import qupath.lib.images.servers.AbstractTileableImageServer;
import qupath.lib.images.servers.ImageServer;
import qupath.lib.images.servers.ImageServerBuilder;
import qupath.lib.images.servers.ImageServerMetadata;
import qupath.lib.images.servers.ImageServers;
import qupath.lib.images.servers.TileRequest;

public class ZConcatenatedImageServer
extends AbstractTileableImageServer {
    private final List<ImageServer<BufferedImage>> servers;
    private final ImageServerMetadata metadata;

    ZConcatenatedImageServer(List<ImageServer<BufferedImage>> servers, Number zSpacingMicrons) {
        if (servers.isEmpty()) {
            throw new IllegalArgumentException("The provided list of image servers is empty");
        }
        List<ImageServerMetadata> metadata = servers.stream().map(ImageServer::getMetadata).toList();
        ZConcatenatedImageServer.checkUniqueMetadata(metadata, ImageServerMetadata::getWidth, "width");
        ZConcatenatedImageServer.checkUniqueMetadata(metadata, ImageServerMetadata::getHeight, "height");
        ZConcatenatedImageServer.checkUniqueMetadata(metadata, ImageServerMetadata::getPixelCalibration, "pixel calibration");
        ZConcatenatedImageServer.checkUniqueMetadata(metadata, ImageServerMetadata::isRGB, "RGB formats");
        ZConcatenatedImageServer.checkUniqueMetadata(metadata, ImageServerMetadata::getPixelType, "pixel type");
        ZConcatenatedImageServer.checkUniqueMetadata(metadata, ImageServerMetadata::getSizeT, "number of time points");
        ZConcatenatedImageServer.checkUniqueMetadata(metadata, ImageServerMetadata::getChannels, "channels");
        ZConcatenatedImageServer.checkUniqueMetadata(metadata, ImageServerMetadata::getChannelType, "channel type");
        ZConcatenatedImageServer.checkUniqueMetadata(metadata, ImageServerMetadata::getClassificationLabels, "classification labels");
        ZConcatenatedImageServer.checkUniqueMetadata(metadata, ImageServerMetadata::getMagnification, "magnification");
        if (metadata.stream().map(ImageServerMetadata::getSizeZ).anyMatch(sizeZ -> sizeZ != 1)) {
            throw new IllegalArgumentException(String.format("The number of z-stacks of one of the provided servers %s is not 1", servers));
        }
        this.servers = servers;
        this.metadata = new ImageServerMetadata.Builder(servers.getFirst().getMetadata()).name(String.format("Concatenation of %s", metadata.stream().map(ImageServerMetadata::getName).toList())).zSpacingMicrons(zSpacingMicrons).sizeZ(servers.size()).build();
    }

    @Override
    protected ImageServerBuilder.ServerBuilder<BufferedImage> createServerBuilder() {
        return new ImageServers.ZConcatenatedImageServerBuilder(this.getMetadata(), this.servers.stream().map(ImageServer::getBuilder).toList());
    }

    @Override
    protected String createID() {
        return String.format("%s: %s", this.getClass().getName(), this.getURIs());
    }

    @Override
    protected BufferedImage readTile(TileRequest tileRequest) throws IOException {
        ImageServer<BufferedImage> server = this.servers.get(tileRequest.getZ());
        return server.readRegion(tileRequest.getRegionRequest().updatePath(server.getPath()).updateZ(0));
    }

    @Override
    public Collection<URI> getURIs() {
        return this.servers.stream().map(ImageServer::getURIs).flatMap(Collection::stream).toList();
    }

    @Override
    public String getServerType() {
        return "Z-concatenated image server";
    }

    @Override
    public ImageServerMetadata getOriginalMetadata() {
        return this.metadata;
    }

    private static <T> void checkUniqueMetadata(List<ImageServerMetadata> metadata, Function<ImageServerMetadata, T> metadataGetter, String metadataLabel) {
        List<T> distinctMetadata = metadata.stream().map(metadataGetter).distinct().toList();
        if (distinctMetadata.size() > 1) {
            throw new IllegalArgumentException(String.format("The provided image server %s %s are not the same", metadataLabel, distinctMetadata));
        }
    }
}

