/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.images.servers;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import qupath.lib.awt.common.BufferedImageTools;
import qupath.lib.images.servers.AbstractTileableImageServer;
import qupath.lib.images.servers.ImageChannel;
import qupath.lib.images.servers.ImageServerBuilder;
import qupath.lib.images.servers.ImageServerMetadata;
import qupath.lib.images.servers.PixelType;
import qupath.lib.images.servers.TileRequest;

public class WrappedBufferedImageServer
extends AbstractTileableImageServer {
    private ImageServerMetadata originalMetadata;
    private BufferedImage img;
    private final int[] rgbTypes = new int[]{2, 3, 1};

    public WrappedBufferedImageServer(String imageName, BufferedImage img) {
        this(imageName, img, null);
    }

    public WrappedBufferedImageServer(String imageName, BufferedImage img, List<ImageChannel> channels) {
        this.img = BufferedImageTools.duplicate(img);
        PixelType pixelType = switch (img.getRaster().getSampleModel().getTransferType()) {
            case 0 -> PixelType.UINT8;
            case 1 -> PixelType.UINT16;
            case 4 -> PixelType.FLOAT32;
            case 5 -> PixelType.FLOAT64;
            case 2 -> PixelType.INT16;
            case 3 -> PixelType.INT32;
            default -> throw new IllegalArgumentException("Unsupported image data type " + img.getRaster().getDataBuffer().getDataType());
        };
        int nChannels = img.getSampleModel().getNumBands();
        boolean isRGB = false;
        for (int type : this.rgbTypes) {
            if (type != img.getType()) continue;
            isRGB = true;
            pixelType = PixelType.UINT8;
        }
        if (channels == null) {
            channels = isRGB ? ImageChannel.getDefaultRGBChannels() : ImageChannel.getDefaultChannelList(nChannels);
        }
        this.originalMetadata = new ImageServerMetadata.Builder().width(img.getWidth()).height(img.getHeight()).name(imageName).preferredTileSize(img.getWidth(), img.getHeight()).levelsFromDownsamples(1.0).rgb(isRGB).pixelType(pixelType).channels(channels).build();
    }

    @Override
    public Collection<URI> getURIs() {
        return Collections.emptyList();
    }

    @Override
    protected String createID() {
        return UUID.randomUUID().toString();
    }

    @Override
    public String getServerType() {
        return "BufferedImage wrapper";
    }

    @Override
    public ImageServerMetadata getOriginalMetadata() {
        return this.originalMetadata;
    }

    @Override
    protected ImageServerBuilder.ServerBuilder<BufferedImage> createServerBuilder() {
        return null;
    }

    @Override
    protected BufferedImage readTile(TileRequest tileRequest) throws IOException {
        if (tileRequest.getDownsample() != 1.0 || tileRequest.getImageX() != 0 || tileRequest.getImageY() != 0 || tileRequest.getImageWidth() != this.img.getWidth() || tileRequest.getImageHeight() != this.img.getHeight()) {
            throw new IllegalArgumentException("Invalid tile request! Only the full image can be returned, but I got a request for " + String.valueOf(tileRequest));
        }
        return this.img;
    }
}

