/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.images.servers;

import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import qupath.lib.color.ColorDeconvolutionStains;
import qupath.lib.images.servers.AffineTransformImageServer;
import qupath.lib.images.servers.ChannelTransformFeatureServer;
import qupath.lib.images.servers.ColorDeconvolutionImageServer;
import qupath.lib.images.servers.ColorTransforms;
import qupath.lib.images.servers.ConcatChannelsImageServer;
import qupath.lib.images.servers.CroppedImageServer;
import qupath.lib.images.servers.ImageServer;
import qupath.lib.images.servers.NormalizedImageServer;
import qupath.lib.images.servers.PixelType;
import qupath.lib.images.servers.RearrangeRGBImageServer;
import qupath.lib.images.servers.RotatedImageServer;
import qupath.lib.images.servers.SlicedImageServer;
import qupath.lib.images.servers.TypeConvertImageServer;
import qupath.lib.images.servers.ZConcatenatedImageServer;
import qupath.lib.images.servers.ZProjectedImageServer;
import qupath.lib.images.servers.transforms.BufferedImageNormalizer;
import qupath.lib.images.servers.transforms.ColorDeconvolutionNormalizer;
import qupath.lib.images.servers.transforms.SubtractOffsetAndScaleNormalizer;
import qupath.lib.regions.ImageRegion;

public class TransformedServerBuilder {
    private ImageServer<BufferedImage> server;

    public TransformedServerBuilder(ImageServer<BufferedImage> baseServer) {
        this.server = baseServer;
    }

    public TransformedServerBuilder crop(ImageRegion region) {
        this.server = new CroppedImageServer(this.server, region);
        return this;
    }

    public TransformedServerBuilder slice(int zStart, int zEnd, int tStart, int tEnd) {
        return this.slice(zStart, zEnd, 1, tStart, tEnd, 1);
    }

    public TransformedServerBuilder slice(int zStart, int zEnd, int zStep, int tStart, int tEnd, int tStep) {
        this.server = new SlicedImageServer(this.server, zStart, zEnd, zStep, tStart, tEnd, tStep);
        return this;
    }

    public TransformedServerBuilder zProjectMean() {
        return this.zProject(ZProjectedImageServer.Projection.MEAN);
    }

    public TransformedServerBuilder zProjectMin() {
        return this.zProject(ZProjectedImageServer.Projection.MIN);
    }

    public TransformedServerBuilder zProjectMax() {
        return this.zProject(ZProjectedImageServer.Projection.MAX);
    }

    public TransformedServerBuilder zProjectSum() {
        return this.zProject(ZProjectedImageServer.Projection.SUM);
    }

    public TransformedServerBuilder zProjectStandardDeviation() {
        return this.zProject(ZProjectedImageServer.Projection.STANDARD_DEVIATION);
    }

    public TransformedServerBuilder zProjectMedian() {
        return this.zProject(ZProjectedImageServer.Projection.MEDIAN);
    }

    public TransformedServerBuilder zProject(ZProjectedImageServer.Projection projection) {
        this.server = new ZProjectedImageServer(this.server, projection, -1);
        return this;
    }

    public TransformedServerBuilder zProject(ZProjectedImageServer.Projection projection, int offset) {
        this.server = new ZProjectedImageServer(this.server, projection, offset);
        return this;
    }

    public TransformedServerBuilder zProjectMax(int offset) {
        return this.zProject(ZProjectedImageServer.Projection.MAX, offset);
    }

    public TransformedServerBuilder zProjectMin(int offset) {
        return this.zProject(ZProjectedImageServer.Projection.MIN, offset);
    }

    public TransformedServerBuilder zProjectMean(int offset) {
        return this.zProject(ZProjectedImageServer.Projection.MEAN, offset);
    }

    public TransformedServerBuilder zProjectMedian(int offset) {
        return this.zProject(ZProjectedImageServer.Projection.MEDIAN, offset);
    }

    public TransformedServerBuilder zProjectStandardDeviation(int offset) {
        return this.zProject(ZProjectedImageServer.Projection.STANDARD_DEVIATION, offset);
    }

    public TransformedServerBuilder concatToZStack(List<ImageServer<BufferedImage>> servers) {
        return this.concatToZStack(servers, null);
    }

    public TransformedServerBuilder concatToZStack(List<ImageServer<BufferedImage>> servers, Number zSpacingMicrons) {
        ArrayList<ImageServer<BufferedImage>> allServers = new ArrayList<ImageServer<BufferedImage>>(servers);
        if (!allServers.contains(this.server)) {
            allServers.addFirst(this.server);
        }
        this.server = new ZConcatenatedImageServer(allServers, zSpacingMicrons);
        return this;
    }

    public TransformedServerBuilder transform(AffineTransform transform) {
        try {
            this.server = new AffineTransformImageServer(this.server, transform);
        }
        catch (NoninvertibleTransformException e) {
            throw new IllegalArgumentException(e);
        }
        return this;
    }

    public TransformedServerBuilder deconvolveStains(ColorDeconvolutionStains stains, int ... stainNumbers) {
        this.server = new ColorDeconvolutionImageServer(this.server, stains, stainNumbers);
        return this;
    }

    public TransformedServerBuilder reorderRGB(String order) {
        this.server = new RearrangeRGBImageServer(this.server, order);
        return this;
    }

    public TransformedServerBuilder rotate(RotatedImageServer.Rotation rotation) {
        this.server = new RotatedImageServer(this.server, rotation);
        return this;
    }

    public TransformedServerBuilder extractChannels(int ... channels) {
        ArrayList<ColorTransforms.ColorTransform> transforms = new ArrayList<ColorTransforms.ColorTransform>();
        for (int c : channels) {
            transforms.add(ColorTransforms.createChannelExtractor(c));
        }
        this.server = new ChannelTransformFeatureServer(this.server, transforms);
        return this;
    }

    public TransformedServerBuilder extractChannels(String ... names) {
        ArrayList<ColorTransforms.ColorTransform> transforms = new ArrayList<ColorTransforms.ColorTransform>();
        for (String n : names) {
            transforms.add(ColorTransforms.createChannelExtractor(n));
        }
        this.server = new ChannelTransformFeatureServer(this.server, transforms);
        return this;
    }

    public TransformedServerBuilder maxChannelProject() {
        this.server = new ChannelTransformFeatureServer(this.server, List.of(ColorTransforms.createMaximumChannelTransform()));
        return this;
    }

    public TransformedServerBuilder averageChannelProject() {
        this.server = new ChannelTransformFeatureServer(this.server, List.of(ColorTransforms.createMeanChannelTransform()));
        return this;
    }

    public TransformedServerBuilder minChannelProject() {
        this.server = new ChannelTransformFeatureServer(this.server, List.of(ColorTransforms.createMinimumChannelTransform()));
        return this;
    }

    public TransformedServerBuilder concatChannels(Collection<ImageServer<BufferedImage>> additionalChannels) {
        ArrayList<ImageServer<BufferedImage>> allChannels = new ArrayList<ImageServer<BufferedImage>>(additionalChannels);
        if (!allChannels.contains(this.server)) {
            allChannels.add(0, this.server);
        }
        this.server = new ConcatChannelsImageServer(this.server, allChannels);
        return this;
    }

    public TransformedServerBuilder concatChannels(ImageServer<BufferedImage> ... additionalChannels) {
        for (ImageServer<BufferedImage> temp : additionalChannels) {
            if (BufferedImage.class.isAssignableFrom(temp.getImageClass())) continue;
            throw new IllegalArgumentException("Unsupported ImageServer type, required BufferedImage.class but server supports " + String.valueOf(temp.getImageClass()));
        }
        return this.concatChannels(Arrays.asList(additionalChannels));
    }

    public TransformedServerBuilder subtractOffset(double ... offsets) {
        return this.normalize(SubtractOffsetAndScaleNormalizer.createSubtractOffset(offsets));
    }

    public TransformedServerBuilder subtractOffsetAndClipZero(double ... offsets) {
        return this.normalize(SubtractOffsetAndScaleNormalizer.createSubtractOffsetAndClipZero(offsets));
    }

    public TransformedServerBuilder subtractOffsetAndScale(double[] offsets, double[] scales) {
        return this.normalize(SubtractOffsetAndScaleNormalizer.create(offsets, scales));
    }

    public TransformedServerBuilder scaleChannels(double ... scales) {
        return this.normalize(SubtractOffsetAndScaleNormalizer.create(null, scales));
    }

    public TransformedServerBuilder stainNormalize(ColorDeconvolutionStains stainsInput, ColorDeconvolutionStains stainsOutput, double ... scales) {
        return this.normalize(ColorDeconvolutionNormalizer.create(stainsInput, stainsOutput, scales));
    }

    public TransformedServerBuilder normalize(BufferedImageNormalizer normalizer) {
        this.server = new NormalizedImageServer(this.server, normalizer);
        return this;
    }

    public TransformedServerBuilder applyColorTransforms(Collection<? extends ColorTransforms.ColorTransform> transforms) {
        this.server = new ChannelTransformFeatureServer(this.server, new ArrayList<ColorTransforms.ColorTransform>(transforms));
        return this;
    }

    public TransformedServerBuilder applyColorTransforms(ColorTransforms.ColorTransform ... transforms) {
        return this.applyColorTransforms(Arrays.asList(transforms));
    }

    public TransformedServerBuilder convertType(PixelType pixelType) {
        this.server = new TypeConvertImageServer(this.server, pixelType);
        return this;
    }

    public ImageServer<BufferedImage> build() {
        return this.server;
    }
}

