/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.images.servers;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Map;
import java.util.stream.Stream;
import qupath.lib.images.servers.ImageServer;
import qupath.lib.images.servers.ImageServerBuilder;
import qupath.lib.images.servers.ImageServerMetadata;
import qupath.lib.images.servers.ImageServers;
import qupath.lib.images.servers.TransformingImageServer;
import qupath.lib.io.GsonTools;
import qupath.lib.regions.RegionRequest;

public class SlicedImageServer
extends TransformingImageServer<BufferedImage> {
    private final int zStart;
    private final int zEnd;
    private final int zStep;
    private final int tStart;
    private final int tEnd;
    private final int tStep;
    private final ImageServerMetadata metadata;

    SlicedImageServer(ImageServer<BufferedImage> inputServer, int zStart, int zEnd, int zStep, int tStart, int tEnd, int tStep) {
        super(inputServer);
        this.zStart = SlicedImageServer.setNumberInRange(zStart, 0, inputServer.nZSlices() - 1);
        this.zEnd = SlicedImageServer.setNumberInRange(zEnd, 1, inputServer.nZSlices());
        this.zStep = zStep;
        this.tStart = SlicedImageServer.setNumberInRange(tStart, 0, inputServer.nTimepoints() - 1);
        this.tEnd = SlicedImageServer.setNumberInRange(tEnd, 1, inputServer.nTimepoints());
        this.tStep = tStep;
        SlicedImageServer.checkOrder(this.zStart, this.zEnd, "z-slice");
        SlicedImageServer.checkStep(this.zStep);
        SlicedImageServer.checkOrder(this.tStart, this.tEnd, "timepoint");
        SlicedImageServer.checkStep(this.tStep);
        this.metadata = new ImageServerMetadata.Builder(inputServer.getMetadata()).sizeZ((this.zEnd - this.zStart + this.zStep - 1) / this.zStep).sizeT((this.tEnd - this.tStart + this.tStep - 1) / this.tStep).zSpacingMicrons(inputServer.getMetadata().getZSpacingMicrons() * (double)this.zStep).timepoints(inputServer.getMetadata().getPixelCalibration().getTimeUnit(), Stream.iterate(this.tStart, t -> t < this.tEnd, t -> t + this.tStep).mapToDouble(i -> inputServer.getMetadata().getPixelCalibration().getTimepoint((int)i)).toArray()).build();
    }

    @Override
    protected ImageServerBuilder.ServerBuilder<BufferedImage> createServerBuilder() {
        return new ImageServers.SlicedImageServerBuilder(this.getMetadata(), this.getWrappedServer().getBuilder(), this.zStart, this.zEnd, this.zStep, this.tStart, this.tEnd, this.tStep);
    }

    @Override
    protected String createID() {
        return this.getClass().getName() + ": + " + this.getWrappedServer().getPath() + " " + GsonTools.getInstance().toJson(Map.of("minZSlice", this.zStart, "maxZSlice", this.zEnd, "stepZSlice", this.zStep, "minTimepoint", this.tStart, "maxTimepoint", this.tEnd, "stepTimepoint", this.tStep));
    }

    @Override
    public String getServerType() {
        return "Sliced image server";
    }

    @Override
    public ImageServerMetadata getOriginalMetadata() {
        return this.metadata;
    }

    @Override
    public BufferedImage readRegion(RegionRequest request) throws IOException {
        return (BufferedImage)this.getWrappedServer().readRegion(RegionRequest.createInstance(request.getPath(), request.getDownsample(), request.getX(), request.getY(), request.getWidth(), request.getHeight(), request.getZ() * this.zStep + this.zStart, request.getT() * this.tStep + this.tStart));
    }

    private static int setNumberInRange(int number, int min, int max) {
        return Math.max(min, Math.min(number, max));
    }

    private static void checkOrder(int min, int max, String name) {
        if (min > max) {
            throw new IllegalArgumentException(String.format("The min %s is greater than the max %s", name, name));
        }
    }

    private static void checkStep(int step) {
        if (step < 1) {
            throw new IllegalArgumentException(String.format("The step %s is less than or equal to 0", step));
        }
    }
}

