/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.images.servers;

import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.net.URI;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.IntSummaryStatistics;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import qupath.lib.common.GeneralTools;
import qupath.lib.images.servers.ImageChannel;
import qupath.lib.images.servers.ImageServer;
import qupath.lib.images.servers.ImageServerMetadata;
import qupath.lib.objects.classes.PathClass;
import qupath.lib.objects.classes.PathClassTools;
import qupath.lib.regions.Padding;
import qupath.lib.regions.RegionRequest;

public class ServerTools {
    public static String getDefaultShortServerName(URI uri) {
        Path path = GeneralTools.toPath(uri);
        if (path != null) {
            return path.getFileName().toString();
        }
        String path2 = URLDecoder.decode(uri.toString(), StandardCharsets.UTF_8);
        int ind = path2.lastIndexOf("/") + 1;
        return path2.substring(ind);
    }

    public static int getChannelIndex(ImageServer<?> server, String channelName) {
        int i = 0;
        for (ImageChannel channel : server.getMetadata().getChannels()) {
            if (channelName.equals(channel.getName())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int getPreferredResolutionLevel(ImageServer<?> server, double requestedDownsample) {
        ImageServerMetadata metadata = server.getMetadata();
        double downsampleFactor = Math.max(requestedDownsample, metadata.getDownsampleForLevel(0));
        int n = metadata.nLevels();
        int bestDownsampleSeries = -1;
        double bestDownsampleDiff = Double.POSITIVE_INFINITY;
        for (int i = 0; i < n; ++i) {
            double d = metadata.getDownsampleForLevel(i);
            double downsampleDiff = downsampleFactor - d;
            if (Double.isNaN(downsampleDiff) || !(downsampleDiff >= 0.0) && !GeneralTools.almostTheSame(downsampleFactor, d, 0.01) || !(downsampleDiff < bestDownsampleDiff)) continue;
            bestDownsampleSeries = i;
            bestDownsampleDiff = Math.abs(downsampleDiff);
        }
        return bestDownsampleSeries;
    }

    public static double getPreferredDownsampleFactor(ImageServer<?> server, double requestedDownsample) {
        int level = ServerTools.getPreferredResolutionLevel(server, requestedDownsample);
        return server.getDownsampleForResolution(level);
    }

    public static String getDisplayableImageName(ImageServer<?> server) {
        if (server == null) {
            return "No image";
        }
        String name = server.getMetadata().getName();
        if (name == null) {
            name = server.getURIs().stream().map(uri -> ServerTools.getDefaultShortServerName(uri)).collect(Collectors.joining(", "));
            if (name != null && !name.isBlank()) {
                return name;
            }
            return server.getPath();
        }
        return name;
    }

    public static boolean setImageName(ImageServer<?> server, String name) {
        Objects.requireNonNull(server);
        Objects.requireNonNull(name);
        if (name.equals(server.getMetadata().getName())) {
            return false;
        }
        ImageServerMetadata metadata2 = new ImageServerMetadata.Builder(server.getMetadata()).name(name).build();
        server.setMetadata(metadata2);
        return true;
    }

    private static double getPreferredDownsampleForPixelSizeMicrons(double serverPixelSizeMicrons, double requestedPixelSizeMicrons, boolean doLog2) {
        if (Double.isNaN(serverPixelSizeMicrons + requestedPixelSizeMicrons)) {
            return Double.NaN;
        }
        if (doLog2) {
            return Math.pow(2.0, Math.round(Math.log(requestedPixelSizeMicrons / serverPixelSizeMicrons) / Math.log(2.0)));
        }
        return requestedPixelSizeMicrons / serverPixelSizeMicrons;
    }

    public static double getDownsampleFactor(ImageServer<?> server, double preferredPixelSizeMicrons) {
        if (server == null) {
            return Double.NaN;
        }
        double downsampleFactor = ServerTools.getPreferredDownsampleForPixelSizeMicrons(server.getPixelCalibration().getAveragedPixelSizeMicrons(), preferredPixelSizeMicrons, false);
        if (Double.isNaN(downsampleFactor) || downsampleFactor < 1.0) {
            downsampleFactor = 1.0;
        }
        return downsampleFactor;
    }

    public static BufferedImage getPaddedRequest(ImageServer<BufferedImage> server, RegionRequest request, Padding padding) throws IOException {
        if (padding.isEmpty()) {
            return server.readRegion(request);
        }
        double downsample = request.getDownsample();
        int x = (int)Math.round((double)request.getX() - (double)padding.getX1() * downsample);
        int y = (int)Math.round((double)request.getY() - (double)padding.getY1() * downsample);
        int x2 = (int)Math.round((double)(request.getX() + request.getWidth()) + (double)padding.getX2() * downsample);
        int y2 = (int)Math.round((double)(request.getY() + request.getHeight()) + (double)padding.getY2() * downsample);
        int padLeft = 0;
        int padRight = 0;
        int padUp = 0;
        int padDown = 0;
        boolean outOfRange = false;
        if (x < 0) {
            padLeft = (int)Math.round((double)(-x) / downsample);
            x = 0;
            outOfRange = true;
        }
        if (y < 0) {
            padUp = (int)Math.round((double)(-y) / downsample);
            y = 0;
            outOfRange = true;
        }
        if (x2 > server.getWidth()) {
            padRight = (int)Math.round((double)(x2 - server.getWidth()) / downsample);
            x2 = server.getWidth();
            outOfRange = true;
        }
        if (y2 > server.getHeight()) {
            padDown = (int)Math.round((double)(y2 - server.getHeight()) / downsample);
            y2 = server.getHeight();
            outOfRange = true;
        }
        RegionRequest request2 = RegionRequest.createInstance(request.getPath(), downsample, x, y, x2 - x, y2 - y, request.getZ(), request.getT());
        BufferedImage img = server.readRegion(request2);
        if (outOfRange) {
            int c;
            WritableRaster col;
            int r;
            WritableRaster row;
            WritableRaster raster = img.getRaster();
            WritableRaster rasterPadded = raster.createCompatibleWritableRaster(raster.getWidth() + padLeft + padRight, raster.getHeight() + padUp + padDown);
            rasterPadded.setRect(padLeft, padUp, raster);
            if (padUp > 0) {
                row = raster.createWritableChild(0, 0, raster.getWidth(), 1, 0, 0, null);
                for (r = 0; r < padUp; ++r) {
                    rasterPadded.setRect(padLeft, r, row);
                }
            }
            if (padDown > 0) {
                row = raster.createWritableChild(0, raster.getHeight() - 1, raster.getWidth(), 1, 0, 0, null);
                for (r = padUp + raster.getHeight(); r < rasterPadded.getHeight(); ++r) {
                    rasterPadded.setRect(padLeft, r, row);
                }
            }
            if (padLeft > 0) {
                col = rasterPadded.createWritableChild(padLeft, 0, 1, rasterPadded.getHeight(), 0, 0, null);
                for (c = 0; c < padLeft; ++c) {
                    rasterPadded.setRect(c, 0, col);
                }
            }
            if (padRight > 0) {
                col = rasterPadded.createWritableChild(rasterPadded.getWidth() - padRight - 1, 0, 1, rasterPadded.getHeight(), 0, 0, null);
                for (c = padLeft + raster.getWidth(); c < rasterPadded.getWidth(); ++c) {
                    rasterPadded.setRect(c, 0, col);
                }
            }
            img = new BufferedImage(img.getColorModel(), rasterPadded, img.isAlphaPremultiplied(), null);
        }
        return img;
    }

    public static List<ImageChannel> classificationLabelsToChannels(Map<Integer, PathClass> classificationLabels, boolean ignoredTransparent) {
        IntSummaryStatistics labels = classificationLabels.keySet().stream().mapToInt(i -> i).summaryStatistics();
        if (labels.getMin() < 0) {
            throw new IllegalArgumentException("Classification labels must be >= 0!");
        }
        int nChannels = labels.getMax() + 1;
        ArrayList<ImageChannel> channels = new ArrayList<ImageChannel>();
        int unclassifiedCount = 0;
        for (int i2 = 0; i2 < nChannels; ++i2) {
            PathClass pathClass = classificationLabels.getOrDefault(i2, null);
            if (pathClass == null) {
                channels.add(ImageChannel.getInstance("Unclassified " + ++unclassifiedCount, null));
                continue;
            }
            Integer color = ignoredTransparent && PathClassTools.isIgnoredClass(pathClass) ? null : pathClass.getColor();
            channels.add(ImageChannel.getInstance(pathClass.toString(), color));
        }
        return channels;
    }
}

