/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.images.servers;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import qupath.lib.awt.common.BufferedImageTools;
import qupath.lib.images.servers.ImageServer;
import qupath.lib.images.servers.ImageServerBuilder;
import qupath.lib.images.servers.ImageServers;
import qupath.lib.images.servers.TransformingImageServer;
import qupath.lib.regions.RegionRequest;

public class RearrangeRGBImageServer
extends TransformingImageServer<BufferedImage> {
    private static List<String> VALID_ORDERS = Arrays.asList("RGB", "RBG", "GRB", "GBR", "BRG", "BGR");
    private String order = "RGB";

    protected RearrangeRGBImageServer(ImageServer<BufferedImage> server, String order) {
        super(server);
        if (!server.isRGB()) {
            throw new IllegalArgumentException("Red and blue channels can only be swapped for an RGB image server!");
        }
        this.order = order;
        if (!VALID_ORDERS.contains(order)) {
            throw new IllegalArgumentException("Unsupported order " + order);
        }
    }

    @Override
    public BufferedImage readRegion(RegionRequest request) throws IOException {
        BufferedImage img = (BufferedImage)super.readRegion(request);
        if (img == null) {
            return null;
        }
        BufferedImageTools.swapRGBOrder(img, this.order);
        return img;
    }

    @Override
    public String getServerType() {
        return super.getWrappedServer().getServerType() + " [reorder " + this.order + "]";
    }

    @Override
    protected ImageServerBuilder.ServerBuilder<BufferedImage> createServerBuilder() {
        return new ImageServers.ReorderRGBServerBuilder(this.getMetadata(), this.getWrappedServer().getBuilder(), this.order);
    }

    @Override
    protected String createID() {
        return this.getWrappedServer().getPath() + " [reorder " + this.order + "]";
    }

    public static ImageServerBuilder.ServerBuilder<BufferedImage> getSwapRedBlueBuilder(ImageServerBuilder.ServerBuilder<BufferedImage> builder, String order) {
        if (!VALID_ORDERS.contains(order)) {
            throw new IllegalArgumentException("Unsupported order " + order);
        }
        return new ImageServers.ReorderRGBServerBuilder(null, builder, order);
    }
}

