/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.images.servers;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import qupath.lib.awt.common.BufferedImageTools;
import qupath.lib.images.servers.AbstractTileableImageServer;
import qupath.lib.images.servers.ImageServer;
import qupath.lib.images.servers.ImageServerBuilder;
import qupath.lib.images.servers.ImageServerMetadata;
import qupath.lib.images.servers.ImageServers;
import qupath.lib.images.servers.ServerTools;
import qupath.lib.images.servers.TileRequest;
import qupath.lib.objects.PathObject;
import qupath.lib.objects.PathObjectReader;
import qupath.lib.regions.RegionRequest;

class PyramidGeneratingImageServer
extends AbstractTileableImageServer
implements PathObjectReader {
    private ImageServer<BufferedImage> server;
    private ImageServerMetadata metadata;

    PyramidGeneratingImageServer(ImageServer<BufferedImage> server, int tileWidth, int tileHeight, double ... downsamples) {
        this(server, PyramidGeneratingImageServer.createDefaultMetadata(server, tileWidth, tileHeight, downsamples));
    }

    static ImageServerMetadata createDefaultMetadata(ImageServer<BufferedImage> server, int tileWidth, int tileHeight, double ... downsamples) {
        return new ImageServerMetadata.Builder(server.getMetadata()).preferredTileSize(tileWidth, tileHeight).levelsFromDownsamples(downsamples).build();
    }

    PyramidGeneratingImageServer(ImageServer<BufferedImage> server, ImageServerMetadata metadata) {
        this.server = server;
        this.metadata = metadata;
    }

    @Override
    public Collection<URI> getURIs() {
        return this.server.getURIs();
    }

    @Override
    public String getServerType() {
        return "Generated pyramid (" + this.server.getServerType() + ")";
    }

    @Override
    public ImageServerMetadata getOriginalMetadata() {
        return this.metadata;
    }

    @Override
    protected BufferedImage readTile(TileRequest tileRequest) throws IOException {
        RegionRequest request = tileRequest.getRegionRequest();
        double downsample = request.getDownsample();
        int level = ServerTools.getPreferredResolutionLevel(this, downsample);
        double closestOriginalDownsample = ServerTools.getPreferredDownsampleFactor(this.server, downsample);
        if (level == 0 || closestOriginalDownsample >= this.getDownsampleForResolution(level - 1)) {
            return this.server.readRegion(request.updatePath(this.server.getPath()));
        }
        RegionRequest request2 = request.updateDownsample(this.getDownsampleForResolution(level - 1));
        BufferedImage img = this.readRegion(request2);
        if (img == null || PyramidGeneratingImageServer.isEmptyTile(img)) {
            return this.getEmptyTile(tileRequest.getTileWidth(), tileRequest.getTileHeight());
        }
        return BufferedImageTools.resize(img, tileRequest.getTileWidth(), tileRequest.getTileHeight(), this.allowSmoothInterpolation());
    }

    @Override
    protected boolean allowSmoothInterpolation() {
        if (this.server instanceof AbstractTileableImageServer) {
            return ((AbstractTileableImageServer)this.server).allowSmoothInterpolation();
        }
        return super.allowSmoothInterpolation();
    }

    @Override
    protected ImageServerBuilder.ServerBuilder<BufferedImage> createServerBuilder() {
        ImageServerBuilder.ServerBuilder<BufferedImage> builder = this.server.getBuilder();
        if (builder == null) {
            return null;
        }
        return new ImageServers.PyramidGeneratingServerBuilder(this.getMetadata(), builder);
    }

    @Override
    protected String createID() {
        return this.getClass().getSimpleName() + ":" + this.server.getPath();
    }

    @Override
    public Collection<PathObject> readPathObjects() throws IOException {
        if (this.server instanceof PathObjectReader) {
            return ((PathObjectReader)((Object)this.server)).readPathObjects();
        }
        return Collections.emptyList();
    }
}

