/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.images.servers;

public enum PixelType {
    UINT8(8, PixelValueType.UNSIGNED_INTEGER, 0, 255),
    INT8(8, PixelValueType.SIGNED_INTEGER, (byte)-128, (byte)127),
    UINT16(16, PixelValueType.UNSIGNED_INTEGER, 0, 65535),
    INT16(16, PixelValueType.SIGNED_INTEGER, (short)Short.MIN_VALUE, (short)Short.MAX_VALUE),
    UINT32(32, PixelValueType.UNSIGNED_INTEGER, 0, 0xFFFFFFFFL),
    INT32(32, PixelValueType.SIGNED_INTEGER, Integer.MIN_VALUE, Integer.MAX_VALUE),
    FLOAT32(32, PixelValueType.FLOATING_POINT, Float.valueOf(-3.4028235E38f), Float.valueOf(Float.MAX_VALUE)),
    FLOAT64(64, PixelValueType.FLOATING_POINT, -1.7976931348623157E308, Double.MAX_VALUE);

    private int bitsPerPixel;
    private PixelValueType type;
    private Number minValue;
    private Number maxValue;

    private PixelType(int bpp, PixelValueType type, Number minValue, Number maxValue) {
        this.bitsPerPixel = bpp;
        this.type = type;
        this.minValue = minValue;
        this.maxValue = maxValue;
    }

    public int getBitsPerPixel() {
        return this.bitsPerPixel;
    }

    public Number getLowerBound() {
        return this.minValue;
    }

    public Number getUpperBound() {
        return this.maxValue;
    }

    public int getBytesPerPixel() {
        return (int)Math.ceil((double)this.bitsPerPixel / 8.0);
    }

    public boolean isSignedInteger() {
        return this.type == PixelValueType.SIGNED_INTEGER;
    }

    public boolean isUnsignedInteger() {
        return this.type == PixelValueType.UNSIGNED_INTEGER;
    }

    public boolean isFloatingPoint() {
        return this.type == PixelValueType.FLOATING_POINT;
    }

    private static enum PixelValueType {
        SIGNED_INTEGER,
        UNSIGNED_INTEGER,
        FLOATING_POINT;

    }
}

