/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.images.servers;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import qupath.lib.images.servers.AbstractTileableImageServer;
import qupath.lib.images.servers.ImageServer;
import qupath.lib.images.servers.ImageServerBuilder;
import qupath.lib.images.servers.ImageServerMetadata;
import qupath.lib.images.servers.ImageServers;
import qupath.lib.images.servers.TileRequest;
import qupath.lib.images.servers.transforms.BufferedImageNormalizer;
import qupath.lib.io.GsonTools;

public class NormalizedImageServer
extends AbstractTileableImageServer {
    private final ImageServer<BufferedImage> server;
    private final BufferedImageNormalizer transform;

    protected NormalizedImageServer(ImageServer<BufferedImage> server, BufferedImageNormalizer transform) {
        this.server = server;
        this.transform = transform;
    }

    protected ImageServer<BufferedImage> getWrappedServer() {
        return this.server;
    }

    @Override
    public Collection<URI> getURIs() {
        return this.getWrappedServer().getURIs();
    }

    @Override
    public String getServerType() {
        return "Normalizing image server";
    }

    @Override
    public ImageServerMetadata getOriginalMetadata() {
        return this.server.getOriginalMetadata();
    }

    @Override
    protected BufferedImage readTile(TileRequest tileRequest) throws IOException {
        BufferedImage img = this.getWrappedServer().readRegion(tileRequest.getRegionRequest());
        return img == null ? null : this.transform.filter(img, img);
    }

    @Override
    protected ImageServerBuilder.ServerBuilder<BufferedImage> createServerBuilder() {
        return new ImageServers.NormalizedImageServerBuilder(this.getMetadata(), this.getWrappedServer().getBuilder(), this.transform);
    }

    @Override
    protected String createID() {
        return "Normalized: " + this.getWrappedServer().getPath() + " " + GsonTools.getInstance(false).toJson((Object)this.transform);
    }
}

