/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.images.servers;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.images.servers.ImageServer;
import qupath.lib.images.servers.ImageServerBuilder;
import qupath.lib.io.GsonTools;

public class JsonImageServerBuilder
implements ImageServerBuilder<BufferedImage> {
    private static final Logger logger = LoggerFactory.getLogger(JsonImageServerBuilder.class);

    @Override
    public ImageServerBuilder.UriImageSupport<BufferedImage> checkImageSupport(URI uri, String ... args) {
        float supportLevel = this.supportLevel(uri, args);
        return ImageServerBuilder.UriImageSupport.createInstance(JsonImageServerBuilder.class, supportLevel, ImageServerBuilder.DefaultImageServerBuilder.createInstance(this.getClass(), null, uri, args));
    }

    private float supportLevel(URI uri, String ... args) {
        String lower = uri.toString().toLowerCase();
        if (lower.endsWith(".json")) {
            return 4.0f;
        }
        String scheme = uri.getScheme();
        if (scheme != null && scheme.startsWith("http")) {
            logger.debug("Reading JSON servers via HTTP requests currently not supported - will not check");
            return 0.0f;
        }
        try {
            Path path = Paths.get(uri);
            String type = Files.probeContentType(path);
            if (type == null) {
                return 0.0f;
            }
            if (type.endsWith("/json")) {
                return 4.0f;
            }
            return 0.0f;
        }
        catch (IOException e) {
            logger.trace("Error checking content type", (Throwable)e);
            return 0.0f;
        }
    }

    @Override
    public ImageServer<BufferedImage> buildServer(URI uri, String ... args) throws Exception {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(uri.toURL().openStream(), StandardCharsets.UTF_8));){
            Gson gson = GsonTools.getInstance();
            JsonElement element = (JsonElement)gson.fromJson((Reader)reader, JsonElement.class);
            if (element.isJsonObject()) {
                JsonObject obj = element.getAsJsonObject();
                if (obj.has("builder") && !obj.has("builderType")) {
                    ImageServer imageServer = (ImageServer)gson.fromJson((JsonElement)obj, ImageServer.class);
                    return imageServer;
                }
                if (!obj.has("builderType")) {
                    String builderType = JsonImageServerBuilder.estimateToSetBuilderType(obj);
                    if (builderType == null) {
                        logger.warn("Unknown builder type for JSON object: {}", (Object)obj);
                    } else {
                        logger.debug("Adding estimated builderType property: {}", (Object)builderType);
                        obj.addProperty("builderType", builderType);
                    }
                }
                ImageServerBuilder.ServerBuilder builder = (ImageServerBuilder.ServerBuilder)gson.fromJson((JsonElement)obj, ImageServerBuilder.ServerBuilder.class);
                ImageServer<BufferedImage> imageServer = builder.build();
                return imageServer;
            }
            logger.debug("Attempting to deserialize server, but JSON is not an object: {}", (Object)element);
            ImageServer imageServer = (ImageServer)gson.fromJson(element, ImageServer.class);
            return imageServer;
        }
    }

    private static String estimateToSetBuilderType(JsonObject obj) {
        if (obj.has("builderType")) {
            return obj.get("builderType").getAsString();
        }
        if (JsonImageServerBuilder.hasFields(obj, "providerClassName", "uri", "args")) {
            return "uri";
        }
        if (JsonImageServerBuilder.hasFields(obj, "builder", "rotation")) {
            return "rotated";
        }
        if (JsonImageServerBuilder.hasFields(obj, "builder", "channels")) {
            return "channels";
        }
        if (JsonImageServerBuilder.hasFields(obj, "regions", "path")) {
            return "sparse";
        }
        if (JsonImageServerBuilder.hasFields(obj, "builder", "order")) {
            return "swapRedBlue";
        }
        if (JsonImageServerBuilder.hasFields(obj, "builder", "transforms")) {
            return "color";
        }
        if (JsonImageServerBuilder.hasFields(obj, "builder", "transform")) {
            return "affine";
        }
        if (JsonImageServerBuilder.hasFields(obj, "builder", "region")) {
            return "cropped";
        }
        if (JsonImageServerBuilder.hasFields(obj, "builder", "stains", "channels")) {
            return "color_deconvolved";
        }
        if (JsonImageServerBuilder.hasFields(obj, "builder") && obj.asMap().size() == 1) {
            return "pyramidize";
        }
        if (JsonImageServerBuilder.hasFields(obj, "builder", "realtransforminterpolation")) {
            return "realtransform";
        }
        if (JsonImageServerBuilder.hasFields(obj, "builder", "transforminterpolation")) {
            return "transforminterpolate";
        }
        return null;
    }

    private static boolean hasFields(JsonObject obj, String ... names) {
        for (String name : names) {
            if (obj.has(name)) continue;
            return false;
        }
        return true;
    }

    @Override
    public String getName() {
        return "JSON server builder";
    }

    @Override
    public String getDescription() {
        return "A builder that constructs ImageServers from a JSON representation";
    }

    @Override
    public Class<BufferedImage> getImageType() {
        return BufferedImage.class;
    }
}

