/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.images.servers;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.common.GeneralTools;
import qupath.lib.images.servers.ImageServer;
import qupath.lib.images.servers.ImageServerBuilder;
import qupath.lib.regions.RegionRequest;

public class ImageServerProvider {
    private static final Logger logger = LoggerFactory.getLogger(ImageServerProvider.class);
    private static Map<Class<?>, Map<RegionRequest, ?>> cacheMap = new HashMap();
    private static ServiceLoader<ImageServerBuilder> serviceLoader = ServiceLoader.load(ImageServerBuilder.class);

    public static <T> void setCache(Map<RegionRequest, T> cache, Class<T> cls) {
        cacheMap.put(cls, cache);
    }

    public static <T> Map<RegionRequest, T> getCache(Class<T> cls) {
        return cacheMap.get(cls);
    }

    public static void setServiceLoader(ServiceLoader<ImageServerBuilder> newLoader) {
        serviceLoader = newLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<ImageServerBuilder<?>> getInstalledImageServerBuilders() {
        ArrayList builders = new ArrayList();
        ServiceLoader<ImageServerBuilder> serviceLoader = ImageServerProvider.serviceLoader;
        synchronized (serviceLoader) {
            for (ImageServerBuilder b : ImageServerProvider.serviceLoader) {
                builders.add(b);
            }
        }
        return builders;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> List<ImageServerBuilder<T>> getInstalledImageServerBuilders(Class<T> imageClass) {
        ArrayList<ImageServerBuilder<T>> builders = new ArrayList<ImageServerBuilder<T>>();
        ServiceLoader<ImageServerBuilder> serviceLoader = ImageServerProvider.serviceLoader;
        synchronized (serviceLoader) {
            for (ImageServerBuilder b : ImageServerProvider.serviceLoader) {
                if (!imageClass.equals(b.getImageType())) continue;
                builders.add(b);
            }
        }
        return builders;
    }

    public static URI legacyPathToURI(String path) throws IOException {
        URI uriTemp;
        try {
            if (path.startsWith("file:")) {
                uriTemp = new URI(path);
            } else if (path.startsWith("http")) {
                uriTemp = GeneralTools.toEncodedURI(path);
            } else {
                String delimiter = "::";
                int index = path.indexOf(delimiter);
                String seriesName = null;
                String filePath = path;
                if (index > 0 && index < path.length() - delimiter.length() && !new File(path).exists()) {
                    seriesName = path.substring(index + delimiter.length());
                    filePath = path.substring(0, index);
                }
                uriTemp = new File(filePath).toURI();
                if (seriesName != null) {
                    uriTemp = new URI(uriTemp.getScheme(), uriTemp.getAuthority(), uriTemp.getPath(), "name=" + seriesName, null);
                }
            }
        }
        catch (URISyntaxException e) {
            throw new IOException(e.getLocalizedMessage());
        }
        return uriTemp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> List<ImageServerBuilder.UriImageSupport<T>> getServerBuilders(Class<T> cls, String path, String ... args) throws IOException {
        URI uri = ImageServerProvider.legacyPathToURI(path);
        if ("file".equals(uri.getScheme()) && !Files.exists(Paths.get(uri), new LinkOption[0])) {
            throw new IOException(uri.toString() + " does not exist!");
        }
        HashSet<String> requestedClassnames = new HashSet<String>();
        String key = "--classname";
        if (args.length > 0) {
            int i;
            int n = i = key.equals(args[0]) ? 1 : 0;
            while (i < args.length && !args[i].startsWith("-")) {
                requestedClassnames.add(args[i]);
                ++i;
            }
            args = Arrays.copyOfRange(args, i, args.length);
        }
        ArrayList<ImageServerBuilder.UriImageSupport<T>> supports = new ArrayList<ImageServerBuilder.UriImageSupport<T>>();
        ServiceLoader<ImageServerBuilder> serviceLoader = ImageServerProvider.serviceLoader;
        synchronized (serviceLoader) {
            for (ImageServerBuilder provider : ImageServerProvider.serviceLoader) {
                try {
                    ImageServerBuilder.UriImageSupport support;
                    if (!cls.isAssignableFrom(provider.getImageType()) || !requestedClassnames.isEmpty() && !requestedClassnames.contains(provider.getClass().getName()) && !requestedClassnames.contains(provider.getClass().getSimpleName()) || (support = provider.checkImageSupport(uri, args)) == null || !(support.getSupportLevel() > 0.0f)) continue;
                    supports.add(support);
                }
                catch (Exception e) {
                    logger.error("Error testing provider " + String.valueOf(provider), (Throwable)e);
                }
            }
        }
        Comparator comparator = Collections.reverseOrder(new UriImageSupportComparator());
        supports.sort(comparator);
        return supports;
    }

    public static <T> ImageServerBuilder.UriImageSupport<T> getPreferredUriImageSupport(Class<T> cls, String path, String ... args) throws IOException {
        List<ImageServerBuilder.UriImageSupport<T>> supports = ImageServerProvider.getServerBuilders(cls, path, args);
        for (ImageServerBuilder.UriImageSupport<T> support : supports) {
            ImageServerBuilder.UriImageSupport<T> uriImageSupport;
            block9: {
                ImageServer<T> server = support.getBuilders().get(0).build();
                try {
                    uriImageSupport = support;
                    if (server == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (server != null) {
                            try {
                                server.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        logger.warn("Unable to open {}", support);
                    }
                }
                server.close();
            }
            return uriImageSupport;
        }
        return supports.isEmpty() ? null : supports.get(0);
    }

    public static <T> ImageServer<T> buildServer(String path, Class<T> cls, String ... args) throws IOException {
        Object message;
        List<ImageServerBuilder.UriImageSupport<T>> supports = ImageServerProvider.getServerBuilders(cls, path, args);
        Throwable firstException = null;
        if (!supports.isEmpty()) {
            for (ImageServerBuilder.UriImageSupport<T> support : supports) {
                try {
                    if (support.getBuilders().isEmpty()) continue;
                    ImageServer<T> server = support.getBuilders().get(0).build();
                    return ImageServerProvider.checkServerSize(server);
                }
                catch (Exception e) {
                    if (firstException == null) {
                        firstException = e;
                    }
                    logger.warn("Unable to build server: {}", (Object)e.getLocalizedMessage());
                    logger.debug(e.getLocalizedMessage(), (Throwable)e);
                }
            }
        }
        if (supports.isEmpty()) {
            logger.error("Unable to build whole slide server - check your classpath for a suitable library (e.g. OpenSlide, BioFormats)\n\t");
            logger.error(System.getProperty("java.class.path"));
        }
        Object object = message = firstException == null ? "No supports found" : firstException.getLocalizedMessage();
        if (!((String)message).isBlank()) {
            message = " (" + (String)message + ")";
        }
        throw new IOException("Unable to build a whole slide server for " + path + (String)message, firstException);
    }

    static <T> ImageServer<T> checkServerSize(ImageServer<T> serverNew) throws IOException {
        if (serverNew.nResolutions() > 1) {
            return serverNew;
        }
        long nPixels = (long)serverNew.getWidth() * (long)serverNew.getHeight();
        long nBytes = nPixels * (long)serverNew.nChannels() * (long)serverNew.getMetadata().getPixelType().getBytesPerPixel();
        if (nPixels >= Integer.MAX_VALUE || (double)nBytes > (double)Runtime.getRuntime().maxMemory() * 0.8) {
            throw new IOException(String.format("Image is too large and not a pyramid (%d x %d, %d channel%s)!", serverNew.getWidth(), serverNew.getHeight(), serverNew.nChannels(), serverNew.nChannels() > 1 ? "s" : ""));
        }
        return serverNew;
    }

    static class UriImageSupportComparator<T>
    implements Comparator<ImageServerBuilder.UriImageSupport<T>> {
        UriImageSupportComparator() {
        }

        @Override
        public int compare(ImageServerBuilder.UriImageSupport<T> o1, ImageServerBuilder.UriImageSupport<T> o2) {
            int cmp = Float.compare(o1.getSupportLevel(), o2.getSupportLevel());
            if (cmp != 0) {
                return cmp;
            }
            cmp = Integer.compare(o1.getBuilders().size(), o2.getBuilders().size());
            if (cmp != 0) {
                return cmp;
            }
            return o1.getProviderClass().getName().compareTo(o2.getProviderClass().getName());
        }
    }
}

