/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.images.servers;

import java.io.IOException;
import java.net.URI;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.images.servers.ImageServer;
import qupath.lib.images.servers.ImageServerMetadata;
import qupath.lib.images.servers.ImageServerProvider;
import qupath.lib.images.servers.ImageServers;

public interface ImageServerBuilder<T> {
    public UriImageSupport<T> checkImageSupport(URI var1, String ... var2) throws IOException;

    public ImageServer<T> buildServer(URI var1, String ... var2) throws Exception;

    public String getName();

    public String getDescription();

    public Class<T> getImageType();

    default public boolean matchClassName(String ... classNames) {
        for (String className : classNames) {
            if (!this.getClass().getName().equals(className) && !this.getClass().getSimpleName().equals(className)) continue;
            return true;
        }
        return false;
    }

    public static class DefaultImageServerBuilder<T>
    extends AbstractServerBuilder<T> {
        private static final Logger logger = LoggerFactory.getLogger(DefaultImageServerBuilder.class);
        private String providerClassName;
        private URI uri;
        private String[] args;

        private DefaultImageServerBuilder(String providerClassName, URI uri, String[] args, ImageServerMetadata metadata) {
            super(metadata);
            logger.trace("Creating default server builder for URI: {}", (Object)uri);
            this.providerClassName = providerClassName;
            this.uri = uri;
            this.args = args;
        }

        private DefaultImageServerBuilder(Class<? extends ImageServerBuilder<T>> providerClass, URI uri, String[] args, ImageServerMetadata metadata) {
            this(providerClass == null ? null : providerClass.getName(), uri, args, metadata);
        }

        public static <T> ServerBuilder<T> createInstance(Class<? extends ImageServerBuilder<T>> providerClass, ImageServerMetadata metadata, URI uri, String ... args) {
            return new DefaultImageServerBuilder<T>(providerClass, uri, args, metadata);
        }

        public static <T> ServerBuilder<T> createInstance(Class<? extends ImageServerBuilder<T>> providerClass, URI uri, String ... args) {
            return DefaultImageServerBuilder.createInstance(providerClass, null, uri, args);
        }

        public URI getURI() {
            return this.uri;
        }

        public String[] getArgs() {
            return this.args == null ? null : (String[])this.args.clone();
        }

        @Override
        protected ImageServer<T> buildOriginal() throws Exception {
            boolean failedWithRequestedProvider = false;
            if (this.providerClassName != null) {
                for (ImageServerBuilder<?> provider : ImageServerProvider.getInstalledImageServerBuilders()) {
                    if (!provider.getClass().getName().equals(this.providerClassName)) continue;
                    ImageServer<?> server = provider.buildServer(this.uri, this.args);
                    if (server != null) {
                        return server;
                    }
                    failedWithRequestedProvider = true;
                }
            } else {
                return ImageServers.buildServer(this.uri, this.args);
            }
            String msg = "Unable to build ImageServer for " + URLDecoder.decode(this.uri.toString(), StandardCharsets.UTF_8);
            if (this.args != null && this.args.length > 0) {
                msg = msg + " (args=" + String.valueOf(Arrays.asList(this.args)) + ")";
            }
            if (this.providerClassName != null) {
                msg = !failedWithRequestedProvider ? msg + " - I couldn't find " + this.providerClassName : msg + " with requested provider " + this.providerClassName;
            }
            throw new IOException(msg);
        }

        @Override
        public Collection<URI> getURIs() {
            if (this.uri == null) {
                return Collections.emptyList();
            }
            return Collections.singletonList(this.uri);
        }

        @Override
        public ServerBuilder<T> updateURIs(Map<URI, URI> updateMap) {
            if (this.uri == null) {
                return this;
            }
            URI uriNew = updateMap.getOrDefault(this.uri, null);
            if (uriNew == null) {
                return this;
            }
            return new DefaultImageServerBuilder<T>(this.providerClassName, uriNew, this.args, (ImageServerMetadata)this.getMetadata().orElse(null));
        }

        public String toString() {
            return String.format("DefaultServerBuilder (classname=%s, uri=%s, args=%s)", this.providerClassName, this.uri.toString(), "[" + String.join((CharSequence)", ", this.args) + "]");
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + Arrays.hashCode(this.args);
            result = 31 * result + (this.providerClassName == null ? 0 : this.providerClassName.hashCode());
            result = 31 * result + (this.uri == null ? 0 : this.uri.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DefaultImageServerBuilder other = (DefaultImageServerBuilder)obj;
            if (!Arrays.equals(this.args, other.args)) {
                return false;
            }
            if (this.providerClassName == null ? other.providerClassName != null : !this.providerClassName.equals(other.providerClassName)) {
                return false;
            }
            if (this.uri == null ? other.uri != null : !this.uri.equals(other.uri)) {
                return false;
            }
            return Objects.equals(this.getMetadata(), other.getMetadata());
        }
    }

    public static class UriImageSupport<T> {
        private Class<? extends ImageServerBuilder<T>> providerClass;
        private float supportLevel;
        private List<ServerBuilder<T>> builders = new ArrayList<ServerBuilder<T>>();

        public String toString() {
            return this.getClass().getSimpleName() + " (" + String.valueOf(this.providerClass) + ") support=" + this.supportLevel + ", builders=" + this.builders.size();
        }

        UriImageSupport(Class<? extends ImageServerBuilder<T>> providerClass, float supportLevel, Collection<ServerBuilder<T>> builders) {
            this.providerClass = providerClass;
            this.supportLevel = supportLevel;
            this.builders = Collections.unmodifiableList(new ArrayList<ServerBuilder<T>>(builders));
        }

        public static <T> UriImageSupport<T> createInstance(Class<? extends ImageServerBuilder<T>> providerClass, float supportLevel, Collection<ServerBuilder<T>> builders) {
            return new UriImageSupport<T>(providerClass, supportLevel, builders);
        }

        public static <T> UriImageSupport<T> createInstance(Class<? extends ImageServerBuilder<T>> providerClass, float supportLevel, ServerBuilder<T> builder) {
            return new UriImageSupport<T>(providerClass, supportLevel, Collections.singletonList(builder));
        }

        public Class<? extends ImageServerBuilder<T>> getProviderClass() {
            return this.providerClass;
        }

        public List<ServerBuilder<T>> getBuilders() {
            return this.builders;
        }

        public float getSupportLevel() {
            return this.supportLevel;
        }
    }

    public static abstract class AbstractServerBuilder<T>
    implements ServerBuilder<T> {
        private ImageServerMetadata metadata;

        AbstractServerBuilder(ImageServerMetadata metadata) {
            this.metadata = metadata;
        }

        protected abstract ImageServer<T> buildOriginal() throws Exception;

        @Override
        public Optional<ImageServerMetadata> getMetadata() {
            return Optional.ofNullable(this.metadata);
        }

        @Override
        public ImageServer<T> build() throws Exception {
            ImageServer<T> server = this.buildOriginal();
            if (server == null) {
                return null;
            }
            if (this.metadata != null) {
                server.setMetadata(this.metadata);
            }
            return server;
        }
    }

    public static interface ServerBuilder<T> {
        public ImageServer<T> build() throws Exception;

        public Collection<URI> getURIs();

        public ServerBuilder<T> updateURIs(Map<URI, URI> var1);

        default public Optional<ImageServerMetadata> getMetadata() {
            return Optional.empty();
        }
    }
}

