/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.images.servers;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import qupath.lib.common.ColorTools;

public class ImageChannel {
    private static Map<String, ImageChannel> cache = new HashMap<String, ImageChannel>();
    public static final Integer TRANSPARENT = ColorTools.packARGB(0, 255, 253, 254);
    private String name;
    private Integer color;
    public static final ImageChannel RED = ImageChannel.getInstance("Red", ColorTools.packRGB(255, 0, 0));
    public static final ImageChannel GREEN = ImageChannel.getInstance("Green", ColorTools.packRGB(0, 255, 0));
    public static final ImageChannel BLUE = ImageChannel.getInstance("Blue", ColorTools.packRGB(0, 0, 255));

    public static synchronized ImageChannel getInstance(String name, Integer color) {
        String key = (name = Objects.requireNonNull(name)) + "::" + color;
        ImageChannel channel = cache.get(key);
        if (channel == null) {
            channel = new ImageChannel(name, color);
            cache.put(key, channel);
        }
        return channel;
    }

    public static synchronized List<ImageChannel> getChannelList(String ... names) {
        ArrayList<ImageChannel> list = new ArrayList<ImageChannel>();
        int i = 0;
        for (String name : names) {
            list.add(ImageChannel.getInstance(name, ImageChannel.getDefaultChannelColor(i++)));
        }
        return list;
    }

    public String toString() {
        if (this.color == null) {
            return "Image channel: " + this.name;
        }
        return String.format("Image channel: %s (a=%d, r=%d, g=%d, b=%d)", this.name, ColorTools.alpha(this.color), ColorTools.red(this.color), ColorTools.green(this.color), ColorTools.blue(this.color));
    }

    public static Integer getDefaultChannelColor(int channel) {
        int n = 360;
        if (channel >= n) {
            channel %= n;
        }
        switch (channel) {
            case 0: {
                return ColorTools.packRGB(255, 0, 0);
            }
            case 1: {
                return ColorTools.packRGB(0, 255, 0);
            }
            case 2: {
                return ColorTools.packRGB(0, 0, 255);
            }
            case 3: {
                return ColorTools.packRGB(255, 224, 0);
            }
            case 4: {
                return ColorTools.packRGB(0, 224, 224);
            }
            case 5: {
                return ColorTools.packRGB(255, 0, 224);
            }
        }
        int c = channel;
        int hueInc = 128;
        float hue = (float)(c * hueInc % 360) / 360.0f;
        float saturation = 1.0f - (float)(c / 10) / 20.0f;
        float brightness = 1.0f - (float)(c / 10) / 20.0f;
        return Color.HSBtoRGB(hue, saturation, brightness);
    }

    public static List<ImageChannel> getDefaultRGBChannels() {
        return Arrays.asList(RED, GREEN, BLUE);
    }

    public static List<ImageChannel> getDefaultChannelList(int nChannels) {
        if (nChannels == 1) {
            return Collections.singletonList(ImageChannel.getInstance("Channel 1", ColorTools.packRGB(255, 255, 255)));
        }
        ArrayList<ImageChannel> list = new ArrayList<ImageChannel>();
        for (int i = 0; i < nChannels; ++i) {
            list.add(ImageChannel.getInstance("Channel " + (i + 1), ImageChannel.getDefaultChannelColor(i)));
        }
        return list;
    }

    private ImageChannel(String name, Integer color) {
        this.name = name;
        this.color = color == null ? TRANSPARENT : color;
    }

    public boolean isTransparent() {
        return TRANSPARENT.equals(this.color);
    }

    public String getName() {
        return this.name;
    }

    public Integer getColor() {
        return this.color;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.color == null ? 0 : this.color.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ImageChannel other = (ImageChannel)obj;
        if (this.color == null ? other.color != null : !this.color.equals(other.color)) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }
}

